;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: desc.lisp,v 1.7 2004/08/26 23:24:59 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(export '(gi-desc))

(defun gi-desc ((snepsnode))
  (setq check-flag nil)
  (setq *already-expanded* snepsnode)
  (do-describe (get-children snepsnode *node-list*)))

(defun get-children (nodes instances)
  (cond ((eq (length check-flag) (length nodes)) nodes)
	(t (let ((yy (get-children-printed nodes instances)))
	     (setq check-flag (append nodes yy))
	     (get-children check-flag instances)))))

(defun get-children-printed (nodes instances)
  (cond ((null nodes) nil)
	(t (append (get-kids (car nodes) instances)
                   (get-children-printed (cdr nodes) instances)))))

(defun get-kids (node instance)
  (cond ((eq node (send (car instance) :the-node)) (get-kids1 (car instance) 
							      (send (car instance) :arcs)))
	(t (get-kids node (cdr instance)))))

(defun get-kids1 (node arcs)
  (cond ((null arcs) nil)
	((eq  node (send (car arcs) :node1)) (cons (make-string1 (send (car arcs) :node2))
						    (get-kids1 node (cdr arcs))))
	(t (get-kids1 node (cdr arcs)))))

(defun make-string1 (instance)
  (car (get-node-names (list instance))))


(defun do-describe (node-list)
  (setq *already-expanded* *node-list*)
  (gi-desc111 node-list)
  (do-describe-over (get-unexpanded-nodes *already-expanded* *node-list*)))

(defun do-describe-over (node-list)
  (cond ((done-yet node-list) nil)
   (t (setq *already-expanded* *node-list*)
    (gi-desc111 node-list)
    (do-describe-over (get-unexpanded-nodes *already-expanded* *node-list*)))))

(defun done-yet (node-list)
  (cond ((null node-list) t)
   ((sneps:isbase.n (car node-list)) (done-yet (cdr node-list)))
   (t nil)))


(defun get-unexpanded-nodes (sublist list)
  (get-node-names (remove-drawn-nodes sublist list)))

(defun get-node-names (list-of-instances)
  (cond ((null list-of-instances) nil)
	(t (cons (send (car list-of-instances) :the-node)
		   (get-node-names (cdr list-of-instances))))))

(defun gi-desc111 (node-list)
  (let ((x))
    (do-the-describe node-list (// *xresolution* 6) 0)
    (setq x (remove-drawn-nodes *already-expanded* *node-list*))
    (chris-draw-screen x)))

(defun gi-desc1 (node-list)
  (let ((node-list1 *node-list*)
	(x))
    (do-the-describe node-list (// *xresolution* 6) 0)
    (setq x (remove-drawn-nodes node-list1 *node-list*))
    (chris-draw-screen x)))

(defun do-the-describe (nodelist xboundry count)
  (cond ((null nodelist) t)
	(t (let ((boundry (get-bounds (car nodelist) *node-list*)))
	     (gdescribe (ntost (car nodelist)) (car nodelist) (first boundry) (second boundry)
			(third boundry) (fourth boundry))
	     (do-the-describe (cdr nodelist) xboundry (+ count 1))))))


(defun gdescribe (print-name nod xmin xmax ymin ymax)
  (declare (ignore print-name ymin))
  (let* ((below (findchildren nod))
	 (xres (- xmax xmin))
	 (below1 (remove-drawn-node below))
	 (xbelow-increment (// xres (width 1 below1)))
	 (bd (abovedump ymax xbelow-increment 1 below1 xmin)))
    (print-nodes bd)				; prints down nodes
    (print-arcs below)))			; prints below arcs

















    
    




