;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: ds1.lisp,v 1.6 2004/08/26 23:24:59 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(defun DRAW-SCREEN (nl)
  (DRAW-SCREEN-1 nl)
  (DRAW-ARCS *node-list*))


(defun DRAW-SCREEN-1 (n)
  (cond ((null n) t)
	(t (or (send (car n) :draw-self window)	
	       (DRAW-SCREEN-1 (cdr n))))))

(defun DRAW-ARCS (n)
  (cond ((null n) t)
	(t (DRAW-ARCS-1 (car n) (send (car n) :arcs))
	   (DRAW-ARCS (cdr n)))))

(defun DRAW-ARCS-1 (n arcs)
  (cond ((null arcs) t)
	(t (cond ((already-drawn (car arcs)) (DRAW-ARCS-1 n (cdr arcs)))
		 (t (send (car arcs) :draw-self window)
		    (push (car arcs) *drawn-arcs*)
		    (DRAW-ARCS-1 n (cdr arcs)))))))

(defun already-drawn (arc)
  (cond ((null *drawn-arcs*) nil)
	(t (already-drawn-1 arc *drawn-arcs*))))

(defun already-drawn-1 (arc da)
  (cond ((null da) nil)
	(t (or (equal arc (car da)) (already-drawn-1 arc (cdr da))))))

(defun CHRIS-DRAW-SCREEN (nl)
  (chris-DRAW-SCREEN-1 nl)       
  (chris-DRAW-ARCS *node-list*))

(defun chris-DRAW-SCREEN-1 (n)
  (cond ((null n) t)
	(t (send (car n) :draw-self window)
	   (chris-DRAW-SCREEN-1 (cdr n)))))

(defun chris-DRAW-ARCS (n)
  (cond ((null n) t)
	(t (chris-DRAW-ARCS-1 (car n) (send (car n) :arcs))
	   (chris-DRAW-ARCS (cdr n)))))

(defun chris-DRAW-ARCS-1 (n arcs)
  (cond ((null arcs) t)
	(t (cond ((chris-already-drawn (car arcs)) (chris-DRAW-ARCS-1 n (cdr arcs)))
		 (t (send (car arcs) :draw-self window)
		    (push (car arcs) *drawn-arcs1*)
		    ;(draw-me  (car arcs))
		    (chris-DRAW-ARCS-1 n (cdr arcs)))))))

(defun chris-already-drawn (arc)
  (cond ((null *drawn-arcs1*) nil)
	(t (chris-already-drawn-1 arc *drawn-arcs1*))))

(defun chris-already-drawn-1 (arc da)
  (cond ((null da) nil)
	(t (or (equal arc (car da)) (chris-already-drawn-1 arc (cdr da))))))


(defun redraw ()
  (declare (special terminal-io))
  (send terminal-io :refresh )
  (setq *drawn-arcs1* nil)
  (chris-draw-screen *node-list*))
; (send terminal-io :set-cursorpos 100 100))


(defun draw-me (arc)
  (declare (special bbb))
    (setq bbb (multiple-value-list
		(calculate-edges
		  (send (send arc :node1) :radius)
		  (send (send arc :node1) :xpos)
		  (send (send arc :node1) :ypos)
		  (send (send arc :node2) :radius)
		  (send (send arc :node2) :xpos)
		  (send (send arc :node2) :ypos)
		  (sneps:isbase.n (send (send arc :node2) :the-node)))))
    (draw-tri (third bbb)
	      (fourth bbb)
	      (send (send arc :node2) :xpos)
	      (send (send arc :node2) :ypos)
	      (send (send arc :node1) :xpos)
	      (send (send arc :node1) :ypos)))


(defun draw-tri (xi yi xcenter ycenter x y )
  (declare (special a))
  (let ((size 5))
    (cond ((eq xi x)
	   (cond ((< y yi) (tri xi yi (+ xi size) (- yi size) (- xi size) (- yi size)))
		 (t (tri xi yi (+ xi size) (+ yi size) (- xi size) (+ yi size)))))
	  ((eq yi y)
	   (cond ((< x xi) (tri xi yi (- xi size) (+ yi size) (- xi size) (- yi size)))
		 (t (tri xi yi (+ xi size) (+ yi size) (+ xi size) (- yi size)))))
	  (t (setq a ( atan (/ (- yi y) (- xi x))))
	     (cond ((<= xcenter  x)
		    (cond ((> ycenter y ) (rotate  a xi yi))  
			  (t (rotate  a xi yi ))))	; (+ a (/ (* 3 pi) 2)) xi yi))))
		   
		   ((< ycenter y ) (rotate (+ a pi) xi yi))	; (+ a (/ pi 2)) xi yi))
		   (t (rotate (+ a pi) xi yi )))))))


(defun rotate (aa xi yi)
  (declare (special xx2 yy2 xx3 yy3 r-matrix xy2 xy3))
  (let ((size 5))
    (setq xx2 (+ xi size))
    (setq yy2 (- yi size))
    (setq xx3 (+ xi size ))
    (setq yy3 (+ yi size ))
    (setq r-matrix (make-rot-mat aa xi yi))
    (setq xy2 (matrix-mult (list xx2 yy2 1) r-matrix))
    (setq xy3 (matrix-mult (list xx3 yy3 1) r-matrix))
    (tri xi 
	 yi 
	 (round (first  xy2))
	 (round (second xy2))
	 (round (first  xy3))
	 (round (second xy3)))))


(defun matrix-mult (a b)
  (list (+ (+ (* (first a)  (first (first b)))
	      (* (second a) (first (second b))))
	   (* (third a) (first (third b))))  
	(+ (+ (* (first a)  (second (first b)))
	      (* (second a) (second (second b))))
	   (* (third a) (second (third b))))  
	(+ (+ (* (first a)  (third (first b)))
	      (* (second a) (third (second b))))
	   (* (third a) (third (third b))))))


(defun make-rot-mat (a x y)
  (list (list (cos a) (sin a) 0) 
	(list (* -1 (sin a)) (cos a) 0) 
	(list (+ (* x (- 1 (cos a)))
		 (* y (sin a)))
	      (- (* y (- 1 (cos a)))
		 (* x (sin a)))
	      1)))

(defun tri (x1 y1 x2 y2 x3 y3)
  (list x1 y1 x2 y2 x3 y3))
; (send terminal-io :draw-triangle x1 y1 x2 y2 x3 y3 tv:alu-xor))


(defun my-calc-edges (r1 x1 y1 r2 x2 y2)
  (declare (special dx dy length))
  (setq dx (- x2 x1))
  (setq dy (- y2 y1))
  (setq length (isqrt (+ (* dx dx) (* dy dy))))
  (list (+ x1 (// (* dx r1) length))
	(+ y1 (// (* dy r1) length))
	(- x2 (// (* dx r2) length))
	(- y2 (// (* dy r2) length))))




















    
    




