;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: dump.lisp,v 1.7 2004/08/26 23:24:59 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(export '(gi-dump))

(defun remove-drawn-nodes (sublst lst)
  (cond ((null lst) nil)
	((member22 (send (car lst) :label) sublst)
	 (remove-drawn-nodes sublst (cdr lst)))
	(t (cons (car lst) (remove-drawn-nodes sublst (cdr lst))))))

(defun member22 (x yy)
  (cond ((null yy) nil)
	((equal x (send (car yy) :label)) t)
	(t (member22 x (cdr yy)))))


(defun gi-dump (node-list)
  (let ((bigin-list *node-list*))
    (do-the-dump node-list (floor (/ *xresolution* 5)) 0)
    (chris-draw-screen (remove-drawn-nodes bigin-list *node-list*))))

(defun gdump (nod xmin xmax ymin ymax)
  (let* ((above (findparents nod))
	 (below (findchildren nod))
	 (xres (- xmax xmin))
	 (above1 (remove-drawn-node above))
	 (below1 (remove-drawn-node below))
	 (xabove-increment (// xres (width 1 above)))
	 (xbelow-increment (// xres (width 1 below)))
	 (ad (abovedump ymin xabove-increment 1 above1 xmin))
	 (bd (abovedump ymax xbelow-increment 1 below1 xmin))) 
    (print-nodes ad)				; prints converse nodes
    (print-nodes bd)				; prints down nodes
    (print-arcs above)				; prints above arcs
    (print-arcs below)))			; prints below arcs


(defun do-the-dump (nodelist xboundry count)
  (cond ((null nodelist) t)
	(t (let ((boundry (get-bounds (car nodelist) *node-list*)))
	     (gdump (car nodelist) (first boundry) (second boundry)
		    (third boundry) (fourth boundry))
	     (do-the-dump (cdr nodelist) xboundry (+ count 1))))))


(defun get-bounds (node list)
  (cond ((eq node (send (car list) :the-node))
	 (list (- (send (car list) :xpos) 400)
	       (+ (send (car list) :xpos) 400)
	       (- (send (car list) :ypos) 100)
	       (+ (send (car list) :ypos) 100)))
	(t (get-bounds node (cdr list)))))



(defun remove-drawn-node (mycs)
  (cond ((null mycs) nil)
	((is-drawn (second(first mycs)) *node-list*)
	 (remove-drawn-node (cdr mycs)))
	(t (cons (car mycs)
		 (remove-drawn-node (cdr mycs))))))

(defun is-drawn (node ndlist)
  (cond ((null ndlist) nil)
	((eq node (send (car ndlist) :the-node)) t)
	(t (is-drawn node (cdr ndlist))))) 


(defun findparents (nod)
  (fphelp nod (up.cs (sneps::n-to-cs nod))))


(defun up.cs (cableset)
  (cond ((sneps:isnew.cs cableset) (sneps:new.cs))
	((sneps:isup.r (sneps:relation.c (sneps:choose.cs cableset)))
	 (cons (sneps:choose.cs cableset)
	       (up.cs (sneps:others.cs cableset))))
	(t (up.cs (sneps:others.cs cableset)))))


(defun findchildren(nod)
  (fphelp nod (sneps::down.cs (sneps::n-to-cs nod))))


(defun fphelp (nod cableset)
  (cond ((sneps::isnew.cs cableset) (sneps::new.cs))
	(t (append(bustcable nod (sneps::choose.cs cableset))
		  (fphelp nod (sneps::others.cs cableset))))))

(defun bustcable (nod cable)
  (cond ((issinglelink? cable)
	 (list(list (sneps::relation.c cable)  
		    (sneps::choose.ns (sneps::nodeset.c cable))
		    nod)))
	(t (dividenode nod (sneps::relation.c cable) (sneps::nodeset.c cable)))))

(defun dividenode (nod relation nodes)
  (cond ((sneps::isnew.ns nodes) nil)		; I want a constructor for nil here
	(t (cons (list relation 
		       (sneps::choose.ns nodes)
		       nod)
		 (dividenode nod relation (sneps::others.ns nodes))))))


(defun issinglelink? (cable)
  (cond ((sneps::isnew.ns (sneps::others.ns(sneps::nodeset.c cable))) t)
	(t nil)))

(defun width (num lst)
  (cond ((null lst) num)
	(t (width (+ num 1) (cdr lst)))))

(defun abovedump (y delta num mycs xmin) 
  (cond ((null mycs)  nil)
	(t (cons (addcoordinates delta num y (car mycs) xmin)   
		 (abovedump y delta (+ num 1)(cdr mycs) xmin)))))


(defun addcoordinates (delt num yval cable xmin)
  (append cable (list (+ xmin (* delt num)) yval)))


(defun print-arcs (mycableset)
  
  (let ((mycable (car mycableset)) (dom-node) (wimp-node))
    (cond ((null mycable) nil)
	  ((check-dup mycable)
	   (cond ((eq (remove-front (car mycable)) (remove-converse (car mycable)))
		  (setq dom-node (sneps:node-gi-node (caddr mycable)))
		  (setq wimp-node (sneps:node-gi-node (cadr mycable))))
		 (t (setq dom-node (sneps:node-gi-node (cadr mycable)))
		    (setq wimp-node(sneps:node-gi-node (caddr mycable)))))
	   (make-instance 'arc
			  :arc-label (car mycable)	; relation
			  :node2 wimp-node 
			  :node1 dom-node)
	   (print-arcs (cdr mycableset)))
	  (t (print-arcs (cdr mycableset))))))


(defun check-dup (mycable) 
  (cond ((zlc:string-equal (mystring (remove-front(car mycable)))
			   (mystring (remove-front(remove-converse(car mycable)))))
	 (cond ((or (not (null (get-instance-of-arc(remove-front(car mycable))
						   (sneps:node-gi-node(cadr mycable))
						   (sneps:node-gi-node(caddr mycable)))))
		    (not (null (get-instance-of-arc(remove-front(add-converse(car mycable)))
						   (sneps:node-gi-node(cadr mycable))
						   (sneps:node-gi-node(caddr mycable)))))) nil)
	       (t t)))
	
	((or (not (null (get-instance-of-arc (remove-front (remove-converse(car mycable)))
					     (sneps:node-gi-node (cadr mycable))
					     (sneps:node-gi-node (caddr mycable)))))
	     
	     (not (null (get-instance-of-arc (remove-front(car mycable)) 
					     (sneps:node-gi-node (cadr mycable))
					     (sneps:node-gi-node (caddr mycable)))))) nil)
	(t t)))


(defun remove-front (nod)
  (read-from-string (string-left-trim "sneps::" nod)))


(defun print-nodes (mycableset)
;((arc to from x y)(arc to from x y)()())
;
  (let ((mycable (car mycableset))
	)
    (cond ((null mycableset) t)
	  ((not (member (sneps:node-gi-node (second mycable)) *node-list*))
	   (cond ((any-thing-near (fourth mycable)(fifth mycable) *node-list*) 
		  (print-nodes (change mycableset)))
		 (t (setf (sneps:node-gi-node (second mycable))
			  (make-instance 'node 
					 :label (ntost (second mycable))
					 :xpos (fourth mycable)	; X-coord
					 :ypos (fifth mycable)	; Y-coordinate
					 :the-node (second mycable)))))
	   (print-nodes (cdr mycableset)))
	  
	  (t (print-nodes (cdr mycableset))))))


(defun change (mycs)
  (cons (list (first (car mycs))
	      (second (car mycs))
	      (third (car mycs))
	      (+ (fourth (car mycs)) 5) 
	      (fifth (car mycs)))
	(cdr mycs)))

(defun any-thing-near (x y nodes)
  (cond ((null nodes) nil)
	((and (eq x (send (car nodes) :xpos))
	      (is-arc-near (car nodes) (send (car nodes) :arcs) x y)) t)
	(t (any-thing-near x y (cdr nodes)))))

(defun is-arc-near (node arcs x y)
  (cond ((null arcs) nil)
	((and (eq x (send (send (car arcs) :node1) :xpos))
	      (eq x (send (send (car arcs) :node2) :xpos))) t)
	(t (is-arc-near node (cdr arcs) x y))))

(defun near-x-direction (x nodes)
  (cond ((null nodes) nil)
	((and (> (+ x 10) (send (car nodes) :xpos))
	      (< (- x 10) (send (car nodes) :xpos))) t)
	(t(near-x-direction x (cdr nodes)))))

(defun near-y-direction (y nodes)
  (cond ((null nodes) nil)
	((and (> (+ y 10) (send (car nodes) :ypos))
	      (< (- y 10) (send (car nodes) :ypos))) t)
	(t(near-y-direction y (cdr nodes)))))





    
    




