;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: move.lisp,v 1.6 2004/08/26 23:24:59 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(defun gi-delete ()
  (remove-node clicked-object)
  (send window :refresh))


(defun remove-node (node)
  (send (send node :shapeflavor) :set-alu gwin:erase)
  (send (send node :shapeflavor) :draw window)
  (send (send node :textflavor) :undraw window)
  
  (send world :delete-entity (send node :shapeflavor))
  (send world :delete-entity (send node :textflavor))
  (setq *node-list* (zlc:delete clicked-object *node-list*))
  (remove-arcs (send node :arcs))
  (send node :set-arcs nil))


(defun remove-arcs (arcs)
  (cond ((null arcs) nil)
	(t (let ((sf (send (car arcs) :shapeflavor))
		 (tf (send (car arcs) :textflavor))
		 (trif (send (car arcs) :triangleflavor)))
	     (cond ((and sf tf trif) 
		    (send sf :set-alu gwin:erase)
		    (send tf :set-alu gwin:erase)
		    (send trif :set-alu gwin:erase) 
		    (send sf :draw window)
		    (send tf :draw window)
		    (send trif :undraw window) 
		    (send world :delete-entity (list sf tf trif))
		    (send (car arcs) :set-shapeflavor nil)
		    (send (car arcs) :set-textflavor nil)
		    (send (car arcs) :set-triangleflavor nil)
		    (send (send (car arcs) :node1) :remove-arc (car arcs))
		    (send (send (car arcs) :node2) :remove-arc (car arcs))
		    (remove-arcs (cdr arcs)))
		   (t (remove-arcs (cdr arcs))))))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;GI-MOVE
(defun gi-move-1 (node)
  (erase-node node)
  (send window :refresh)
  (gi-move-11 node)
  (send node :draw-self window)
  (draw-the-new-arcs (send node :arcs)))

(defun erase-node (node)
  (send (send node :shapeflavor) :set-alu gwin:erase)
  (send (send node :shapeflavor) :draw window)
  (send (send node :textflavor) :undraw window)
  
  (send world :delete-entity (send node :shapeflavor))
  (send world :delete-entity (send node :textflavor))
  (erase-arcs (send node :arcs)))


(defun erase-arcs (arcs)
  (cond ((null arcs) nil)
	(t (let ((sf (send (car arcs) :shapeflavor))
		 (tf (send (car arcs) :textflavor))
		 (trif (send (car arcs) :triangleflavor)))
	     (cond ((and sf tf trif) 
		    (send sf :set-alu gwin:erase)
		    (send tf :set-alu gwin:erase)
		    (send trif :set-alu gwin:erase) 
		    (send sf :draw window)
		    (send tf :draw window)
		    (send trif :undraw window)
		    (send world :delete-entity (list sf tf trif))
		    (erase-arcs (cdr arcs)))
		   (t (erase-arcs (cdr arcs))))))))

(defun draw-the-new-arcs (arcs)
  (cond ((null arcs) nil)
	(t (send (car arcs) :draw-self window)
	   (draw-the-new-arcs (cdr arcs)))))

(defun gi-move-11 (node)
  (loop while (equal move-flag t) do 
	(multiple-value-bind (x y) (send window :get-mouse-position)
	  (setq x (floor (+ (/ (- x centerx) current-zoom-factor) centerx)))
	  (setq y (floor (+ (/ (- y centery) current-zoom-factor) centery)))
	  (send node :set-xpos x)
	  (send node :set-ypos y)
	  (send node :draw-fake-node window)
	  (draw-fake-arcs (send node :arcs))
	  (send node :draw-fake-node window)
	  (draw-fake-arcs (send node :arcs)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;draw
;;;;;;

(defmethod (node :draw-fake-node) (window)
  (cond ((sneps:isbase.n the-node)
	 (send window :draw-rectangle (- xpos radius) (- ypos 10)
	       (* radius 2) 20 2 3 tv:alu-xor))
	(t (send window :draw-circle xpos ypos radius 2 3 tv:alu-xor))))

(defun draw-fake-arcs (arcs)
  (cond ((null arcs) nil)
	(t (send (car arcs) :draw-fake-self window)
	   (draw-fake-arcs (cdr arcs)))))

(defmethod (arc :draw-fake-self) (window)
  (multiple-value-bind (x1 y1 x2 y2)
      (calculate-edges (send node1 :radius) (send node1 :xpos) (send node1 :ypos)
		       (send node2 :radius) (send node2 :xpos) (send node2 :ypos)
		       (sneps:isbase.n (send node2 :the-node)))
    (send window :draw-line x1 y1 x2 y2 2 3 tv:alu-xor)))














    
    




