;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: shownode.lisp,v 1.6 2004/08/26 23:24:59 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(defun ntost (node) (format nil "~A" node))

(defun show-node (node-list)
  (setq sn-flag nil)
  (setq *drawn-arcs1* nil)
  (setq *node-list* nil)
  (send window :clear-screen)
  (setq *xresolution* (send window :width))
  (let* ((y-val (// (send window :height) 8))
	 (number-of-nodes (width 0 node-list))
	 (xincrement (floor (/ *xresolution* number-of-nodes)))
	 (center (floor (/ xincrement 2))))
    (cond ((< xincrement 250) (setq xincrement 250)
			      (setq center 125)))
    (show-node-1 node-list xincrement 0 center y-val)
    (chris-draw-screen *node-list*)))

(defun show-node-1 (node-list xincrement count center ycoor)
  (cond ((null node-list) t)
	(t (show-node-2 (ntost (car node-list))
			(car node-list)
			(+ (* xincrement count) center) 
			ycoor)
	   (show-node-1 (cdr node-list)
			xincrement
			(+ count 1)
			center 
			ycoor))))

(defun show-node-2 (print-name nod xcoor ycoor)
  (setf (sneps::node-gi-node nod)
	(make-instance 'node :label print-name :the-node nod :xpos xcoor :ypos ycoor)))







    
    




