;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: desc.lisp,v 1.5 2004/08/26 23:25:02 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(defun gi-desc  (ns)
  "Graphically describe listed nodes."
  (let ((x-increment (// *window-width* (1+ (length ns))))
	(count 1))
    (sneps:do.ns (node ns ns)
      (desc-one-node node count x-increment)
      (setq count (1+ count)))))


(defun desc-one-node (n count x-increment)
  ;; Make and/or draw this node
  (make-and-or-draw-node n 0 count x-increment)
  ;; Describe and connect all of this node's children
  (desc-&-connect-children n))


(defun desc-&-connect-children (parent)
  (let ((X-spacing *default-x-space*)
	(child-count 1))
    (sneps:do.fcs (rel ns (sneps::down.fcs parent) t)
      (sneps:do.ns (child ns t)
	(make-and-or-draw-node child 1 child-count
			       X-spacing (send (sneps::node-gi-node parent) :xpos))
	;; Check if arc between parent and child exists before creating a new one.
	(when (dolist (arc (send (sneps::node-gi-node parent) :arcs) t)
		(when (or (eq (sneps::node-gi-node child) (send arc :node1))
			  (eq (sneps::node-gi-node child) (send arc :node2)))
		  (return nil)))
	  (connect-nodes parent child rel))
	(setq child-count (1+ child-count))))))


(defun connect-nodes (parent child relation)
  (send (make-instance  'arc
			:arc-label  relation
			:node1  (sneps::node-gi-node parent)
			:node2  (sneps::node-gi-node child))
	:draw-self *window*))
 

(defun make-and-or-draw-node (n depth-level number &optional (x-increment 0)(parent-x 0))
  "Make the node, if it doesn't exist, and then display it."
  (let ((gi-node (sneps::node-gi-node n)))
    (cond ((member gi-node *displayed-nodes*)	; Node exists
	   (when (zerop depth-level)		; i.e., Top-level
	     (pan-to-point (send gi-node :xpos) (send gi-node :ypos))))
	  (t					; Node doesn't exist
	   (cond ((zerop depth-level)		; i.e., Top-level
		  (when (= number 1) (pan-to-nearest-edge)); Only first node.
		  (send (setf (sneps::node-gi-node n)
			      (make-instance 'node
					     :label (format nil "~A~:[~;!~]"
							    (sneps::node-na n)
							    (sneps::node-assert n))
					     :the-node n
					     :xpos (+ (left *viewport-position*)
						      (if (plusp x-increment)
							  (* number x-increment)
							  *window-centerx*))
					     :ypos (+ (top *viewport-position*)
						      (// *window-height* 4))))
			:draw-self *window*))
		 (t				; Must be child.
		  (send (setf (sneps::node-gi-node n)
			      (make-instance 'node
					     :label (format nil "~A~:[~;!~]"
							    (sneps::node-na n)
							    (sneps::node-assert n))
					     :the-node n
					     :xpos (if (evenp number)
						       (- parent-x (* number x-increment))
						       (+ parent-x (* number x-increment)))
					     :ypos (round
						     (+ (top *viewport-position*)
							(// *window-height* 4)
							(* depth-level *default-y-space*)))))
			:draw-self *window*)))
	   (expand-display (sneps::node-gi-node n))))))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;






    
    




