;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: dump.lisp,v 1.5 2004/08/26 23:25:02 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(defun gi-dump (ns)
  "Graphically dump the listed nodes."
  (let ((x-increment (// *window-width* (1+ (length ns))))
	(count 1))
    (sneps:do.ns (node ns ns)
      (dump-one-node node count x-increment)
      (setq count (1+ count)))))


(defun dump-one-node (n count x-increment)
  (make-and-or-draw-node n 0 count x-increment)
  (draw-&-connect-parents n)
  (desc-&-connect-children n))

(defun draw-&-connect-parents (child)
  (let ((X-spacing *default-x-space*)
	(parent-count 1))
    (sneps:do.fcs (rel ns (sneps::up.fcs child) t)
      (sneps:do.ns (parent ns t)
	(make-and-or-draw-node parent -0.65 parent-count
			       X-spacing (send (sneps::node-gi-node child) :xpos))
	(when (dolist (arc (send (sneps::node-gi-node child) :arcs) t)
		(when (or (eq (sneps::node-gi-node parent) (send arc :node1))
			  (eq (sneps::node-gi-node parent) (send arc :node2)))
		  (return nil)))
	  (connect-nodes child parent rel))
	(setq parent-count (1+ parent-count))))))

;;;*************************************************************************

 



    
    




