;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: pan.lisp,v 1.5 2004/08/26 23:25:03 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(defun enable-panning ()
  (unless *pan-flag*
    ;; Mark borders as being in Pan Mode.
    (send *window* :set-borders 6)
    (send *window* :deselect)
    (setq *pan-flag* t)
    ;; Activate Panning.
    (scl:process-run-function "GINSENG-Pan-Driver" #'pan-driver)))

(defun disable-panning ()
  (when *pan-flag*
    ;; Return borders to Normal
    (send *window* :set-borders t)
    ;; Turn Panning flag off.
    (setf *pan-flag* nil)
    (send *window* :deselect)))



(defun pan-driver ()
  (multiple-value-bind (x1 y1 x2 y2) (send *window*  :edges)
    
    (loop (unless *pan-flag* (return t))
	  (cond ((< tv:mouse-x (+ x1 5)) 
		 (pan-to-left *default-x-pan*))
		((> tv:mouse-x (- x2 5)) 
		 (pan-to-right *default-x-pan*))
		((< tv:mouse-y (+ y1 5)) 
		 (pan-to-top *default-y-pan*))
		((> tv:mouse-y (- y2 5)) 
		 (pan-to-bottom *default-y-pan*))))))


(defun reset-window-center ()
  "Calculate the current center coordinates for the window."
  (setq *window-centerx* (- (right *viewport-position*) (// *window-width* 2))
	*window-centery* (- (bottom *viewport-position*) (// *window-height* 2))))

(defun pan-to-point (x y)
  "Pan to a specific X,Y point in the drawing."
  (setf (left *viewport-position*) (- x (// *window-width* 2))
	(top *viewport-position*) (round (- y (* *window-height* .25)))
	(right *viewport-position*) (+ x (// *window-width* 2))
	(bottom *viewport-position*) (round (+ y (* *window-width* .75))))
  (reset-window-center)
  (send *window* :clear-screen)
  (send *window* :display))

(defun pan-to-nearest-edge ()
  "Pan so the nearest edge of the drawing is centered."
  (case (nearest-edge)
    (left (pan-to-point (- (left *display-bounds*) (// *window-width* 6))
			(+ (top *viewport-position*) (// *window-height* 4))))
    (top (pan-to-point *window-centerx*
		       (- (top *display-bounds*) (// *window-height* 2))))
    (right (pan-to-point (+ (right *display-bounds*) (// *window-width* 6))
			 (+ (top *viewport-position*) (// *window-height* 4))))
    (bottom (pan-to-point *window-centerx*
			  (+ (bottom *display-bounds*) (// *window-height* 2))))))

(defun pan-to-left (value)
  (setf (left *viewport-position*) (- (left *viewport-position*) value)
	(right *viewport-position*) (- (right *viewport-position*) value))
  (reset-window-center)
  (send *window* :clear-screen)
  (send *window* :display))

(defun pan-to-top (value)
  (setf (top *viewport-position*) (- (top *viewport-position*) value)
	(bottom *viewport-position*) (- (bottom *viewport-position*) value))
  (reset-window-center)
  (send *window* :clear-screen)
  (send *window* :display))

(defun pan-to-right (value)
  (setf (left *viewport-position*) (+ (left *viewport-position*) value)
	(right *viewport-position*) (+ (right *viewport-position*) value))
  (reset-window-center)
  (send *window* :clear-screen)
  (send *window* :display))

(defun pan-to-bottom (value)
  (setf (top *viewport-position*) (+ (top *viewport-position*) value)
	(bottom *viewport-position*) (+ (bottom *viewport-position*) value))
  (reset-window-center)
  (send *window* :clear-screen)
  (send *window* :display))

(defun nearest-edge ()
  "Calculates the edge of the entire drawing that is nearst an edge of the screen.
     This sould allow a user to keep perspective on his location in the diagram when
     he/she describes a new node."
  (let ((lst (list (list (/ (abs (- (left *display-bounds*) (left *viewport-position*)))
			    *window-width*)
			 'left)
		   (list (/ (abs (- (top *display-bounds*) (top *viewport-position*)))
			    *window-height*)
			 'top)
		   (list (/ (abs (- (right *display-bounds*) (right *viewport-position*)))
			    *window-width*)
			 'right)
		   (list (/ (abs (- (bottom *display-bounds*) (bottom *viewport-position*)))
			    *window-height*)
			 'bottom))))
    (cadar (sort lst #'(lambda (a b) (< (car a) (car b)))))))

(defun expand-display (gi-node)
  "Keeps track of the boundaries of the drawing, and expands them as necessary."
  (when (> (left *display-bounds*) (send gi-node :xpos))
    (setf (left *display-bounds*) (- (send gi-node :xpos) (send gi-node :radius))))
  (when (> (top *display-bounds*) (send gi-node :ypos))
    (setf (top *display-bounds*) (- (send gi-node :ypos) (send gi-node :radius))))
  (when (< (right *display-bounds*) (send gi-node :xpos))
    (setf (right *display-bounds*) (+ (send gi-node :xpos) (send gi-node :radius))))
  (when (< (bottom *display-bounds*) (send gi-node :ypos))
    (setf (bottom *display-bounds*) (+ (send gi-node :ypos) (send gi-node :radius)))))






;;;*******************************************************************




    
    




