;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: scale.lisp,v 1.5 2004/08/26 23:25:03 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(defun gi-attributes ()
  (case (send *attrib-menu* :choose)
    (1 (gi-scale 'up))
    (2 (gi-scale 'down))
    (3 (tv:choose-variable-values
	 ;; Modify the default panning distances appropriately.
	 '((*default-x-pan* "Horizontal Increment" :number)
	   (*default-y-pan* "Vertical Increment" :number))
	 ':label '(:string "   Panning Increment Menu"
		   :character-style (:swiss :bold :normal))))))

(setq *attrib-menu* (tv:make-window 'tv:momentary-menu
				 ':label '(:string " Window Attributes Menu "
					   :character-style (:swiss :bold :normal))
				 ':geometry '(1)
				 ':borders 3
				 ':item-list '((" Scale-Up Drawing " :value 1)
					       (" Scale-Down Drawing " :value 2)
					       (" Change Panning Increments " :value 3))))


(defun gi-scale (direction)
  "Changes the font size used for displaying labels, and makes the appropriate
     adjustments to default distances between objects."
  (declare (special *scale-menu*))
  (let (size-num)
    (case direction
      (up ;; Scale Up
	(setf size-num (min 5 (1+ (position *font-size* *avail-font-sizes*)))))
      (down ;;Scale Down
	(setf size-num (max 0 (1- (position *font-size* *avail-font-sizes*))))))
    (setf *font-size* (nth (min 5 size-num) *avail-font-sizes*)
	  *default-x-space* (nth size-num '(23 28 36 44 52 60)) 
	  *default-y-space* (nth size-num '(70 80 100 120 143 170))
	  *min-node-radius* (ceiling (* (1+ size-num) 5))
	  *node-margin-size* (* (1+ size-num) 3))
    (dolist (n *displayed-nodes* t)
    (send n :reset-radius))
    (send *window* :refresh)
    (send *window* :display)))







    
    




