;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: USER; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: load-sneps.lisp,v 1.49 2004/08/26 23:05:27 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA


(in-package #.(if (find-package :cl-user) :cl-user :cl-user))

;; For ANSI Lisps that don't provide LISP and USER packages
;; add them as nicknames to the built-in COMMON-LISP packages:
(if (and (not (find-package :cl))
         (find-package :common-lisp))
    (eval `(defpackage :common-lisp
             (:nicknames ,@(package-nicknames :common-lisp) :cl))))

(if (and (not (find-package :cl-user))
         (find-package :common-lisp-user))
    (eval `(defpackage :common-lisp-user
             (:nicknames ,@(package-nicknames :common-lisp-user) :cl-user))))


;; Key to Features:
;;
;;   unix      --      UNIX operating system
;;   lm-unix   --      Lisp-Machine using a Unix file server
;;   explorer  --      Texas Instruments Explorer
;;   symbolics --      Symbolics Lisp Machine
;;   vms       --      VAX/VMS operating system
;;   allegro   --      Allegro Common-Lisp (Franz Inc.)
;;   lucid     --      Lucid (or Sun) Common-Lisp
;;   cmu       --      CMU Common-Lisp
;;   clisp     --      CLISP by Bruno Haible and Michael Stoll
;;   multimax  --      Kyoto Common Lisp running on an Encore Multimax
;;   mcl       --      Mac Common-Lisp
;;   apple     --      Apple/Mac operating system
;;   lispworks --      Harlequin LispWorks
;;   lpmk      --      Use portable implementation of logical pathnames
;;                     by Mark Kantrowitz


;; Installation instructions (short version, for details see `README'):

;; - Edit `*sneps-directory' (below) to reflect the location (top-level
;;   directory) of your SNePS directory tree.
;; - If you have GARNET installed at your site edit `*sneps-garnet-directory*'
;;   to reflect the directory in which your GARNET load files reside.
;; - If you did rename all Lisp files to conform to the default extension
;;   of your Common-Lisp then edit `*sneps-lisp-extension*' accordingly
;;   (renaming Lisp files is not mandatory even if your Common-Lisp does not
;;   use `.lisp' as its default extension).
;; - Invoke your Common-Lisp and load this file (if you have GARNET installed
;;   at your site make sure your DISPLAY variable is set properly).
;; - Select option `e' (the installation option) from the initial menu.
;; - Ignore all the warnings you'll get during compilation.
;; - If the compilation completed successfully then you are done with the
;;   installation, exit your Common-Lisp.
;; - Optionally set `*sneps-noquery*' (below) to T and `*sneps-verbose*' to NIL
;; - To load SNePS simply load this file and select option `a' from the
;;   initial menu (if you set `*sneps-noquery*' to T you won't be asked).
;; - Run `(sneps)' or `(snepslog)' once SNePS is loaded.
;; - If you get errors because files can't be found during compilation or
;;   loading check whether the various `*sneps-xxx-extension*' variables
;;   have proper values for your Common-Lisp and GARNET installations.


;;; altered for  ACL 6 compatibility (FLJ)  

#+(and allegro-version>= (version>= 6 0))
(progn 
  (setf *pre-sneps-load-case-mode* excl:*current-case-mode*)
  (setf *pre-sneps-load-print-case-mode* *print-case*)
  (case  *current-case-mode*
    (:case-sensitive-lower
     (setf excl::*ignore-package-name-case* t)
     (excl::convert-mixed-case-symbols t) ; nil to preserve mixed-case
     (excl:set-case-mode :case-insensitive-lower)
     (setf *print-case* :downcase))
    (:case-insensitive-lower
     (setf *print-case* :downcase)
     (setf excl::*ignore-package-name-case* t)
     (excl::convert-mixed-case-symbols t))
    (:case-insensitive-upper
     (setf *print-case* :upcase)
     (setf excl::*ignore-package-name-case* t)
     (excl::convert-mixed-case-symbols t)) 
    ))


;;;;;;;;;;;;;;;;;;;; User customization section ;;;;;;;;;;;;;;;;;;;;

;; Edit the following pathname definitions according to the pathname 
;; syntax of your operating system.  Do not include final directory 
;; delimiters; be careful with case for Unix pathnames:

(defvar *sneps-directory*
;;;    #+unix      "/projects/snwiz/Install/Sneps-2.6.0"  ;; at UB
    #+unix      "/sneps/release"
    #+mswindows "snepshost:\\sneps\\release"
    #+explorer  "snepshost:sneps.release"
    #+symbolics "snepshost:>sneps>release"
    #+vms       "snepshost:[sneps.release"
    #+apple     "snepsdisk:sneps"
    "The root of the SNePS directory tree.
Delete the supplied example paths and fill in the actual location
of the top-level SNePS directory at your site.")

(defvar *sneps-garnet-directory* 
;;   "/projects/snwiz/Install/garnet-3.0-alpha-acl6.2"  ;; at UB
    "garnet"
    "The directory that contains the load files of your GARNET installation.
Ignore this variable if you do not have GARNET installed at your site.")

(defvar *sneps-patch-directory* *sneps-directory*
  "The directory used in the definition of the logical host `sneps-p'.
It allows one to load SNePS with user supplied patches that do not
reside in `*sneps-directory*'. Ignore this variable unless you make
modifications to SNePS.")

(defvar *sneps-lisp-extension* "lisp"
  "File extension used for Lisp files of the SNePS distribution.
The default corresponds to the extension that comes with the standard
SNePS distribution. Ignore this variable unless you decided to rename all
Lisp files to conform to the default extension used by your Common-Lisp.")

(defvar *sneps-garnet-lisp-extension* "lisp"
  "File extension used for Lisp files in your GARNET installation.
The default corresponds to the extension that comes with the standard
GARNET distribution. Ignore this variable unless you have trouble
loading GARNET files.")

(defvar *sneps-default-lisp-extension*
    (prog1
        #+unix (prog1
                   #+(or ibcl kcl akcl) "lsp"
                   #+clisp "lisp"  ;;; "lsp" -> "lisp"  FLJ 9/2/02
		   #+gcl "lisp"  ; was "lsp"
                   "lisp")
        #+(or explorer symbolics) "LISP"
        #+vms "LSP"
        "lisp")
  "The default Lisp file extension used by your Common-Lisp.
The defaults provided should probably be ok. Ignore this variable unless
you run into problems with the loading of general Lisp files.")

(defvar *sneps-binary-extension*
    (prog1
        #+unix (prog1
                   #+(or ibcl kcl akcl gcl) "o"
                   #+clisp "fas"
                   #+allegro "fasl"
                   #+cmu "sparcf"
                   #+lucid "sbin"
                   #+lispworks "afasl"
                   "bin")
        #+explorer "XLD"
        #+symbolics "BIN"
        #+vms "FAS"
        #+apple "fasl"
        "bin")
  "The default compiled file extension used by your Common-Lisp.
Because these files are generated by your compiler the defaults provided
will probably be ok. Ignore this variable unless you run into problems
with the loading of compiled Lisp files.")

(defvar *sneps-noquery* nil
  "If this is non-NIL SNePS is loaded without any user interaction.
Use only once the system has been installed and compiled properly.")

(defvar *sneps-verbose* *load-verbose*
  "Set this to T if you want verbose loading of SNePS files.")

(defvar *sneps-load-old-englex* nil
  "If this is T the old englex package is loaded instead of
Chris Lusardi's new implementation (for compatibility with old stuff).")

(defvar *sneps-user-translations* nil
  "List of user supplied logical pathname translations (see below).
Changing the value of this variable after this file was loaded
will not have any effect.")

(defvar *sneps-use-lpmk* (not (fboundp 'translate-logical-pathname))
  "If non-NIL Mark Kantrowitz's logical pathnames package is used.
This should only be non-NIL if there is no native implementation of
logical pathnames available in your Lisp.  If the value is `:redefine'
then additionally standard Lisp functions such as `load', `open',
etc., will be redefined with LPMK versions that understand logical
pathnames.  You can explicitly trigger redefinition by calling
`(lp:redefine-standard-functions)'.  Redefinition is not necessary to
run SNePS, but it gives you the extra convenience of being able to use
logical pathnames throughout.  Some Lisps lock the Lisp package, in
which case you might have to find out how to break that lock before
you can use redefinition.  Even if there is a native implementation of
logical pathnames available it might not work for SNePS.  In this case
setting this variable to `:redefine' might solve the problem by
redefining the native implementation with LPMK.")

(defvar *sneps-compiler-optimization-settings*
  #-cmu '(optimize (speed 2) (compilation-speed 1) (safety 1) (space 0))
  #+cmu nil ;; CMUCL is way to verbose with the above setting.
  "Optimization settings proclaimed during the compilation of SNePS.
The default settings should be ok for most cases, but you can change 
them to suit your needs and Lisp implementation.")

;;; added by flj on 2/12/04 to make sneps run faster
(defvar *fast-sneps-compiler-optimization-settings*
  #-cmu '(optimize (safety 1) (space 1) (speed 3) (debug 1))
  #+cmu nil ;; CMUCL is way to verbose with the above setting.
  "Optimization settings proclaimed during the compilation of SNePS.
The default settings should be ok for most cases, but you can change 
them to suit your needs and Lisp implementation.")

;;;;;;;; end of user customization (below at your own risk) ;;;;;;;;


;; Deal with an old Allegro-3.x problem:
#+allegro (proclaim '(notinline LAST))

;; Symbolic version information (the revision name and the patch level -
;; the number after the `PL:') should match the CVS tag that was used to
;; tag this release):
(defparameter *sneps-version*
    (format nil "SNePS-2.6 [PL:1a ~a]"
	    (let ((date-string "$Date: 2004/08/26 23:05:27 $"))
	      (if (char-equal (aref date-string 0) #\$)
		  (subseq date-string 7 26)
		date-string))))

(defvar *sneps-make-option* :load
  "Used as a value for the MODE parameter of `make-simple-system'.")

(defvar *sneps-optional-systems*
    '("sneps:xginseng;load-xginseng.LISP"
      "sneps:demo;activation;load-activation.LISP"
      "sneps:demo;snere;load-core.LISP"
      "sneps:demo;snere;blocksworld;load-blocksworld.LISP"
      "sneps:demo;snere;arcinfo;load-arc-snactor.LISP")
  "List of optional SNePS system files that need to be installed.")

(defun sneps-startup-query ()
  (format t 
	  "~%~%Do you want to load SNePS

    a) FAST (i.e., just load compiled files)
    b) by compiling source files that are newer than their 
       compiled version before they get loaded
    c) by compiling all source files before they get loaded
    d) by loading uncompiled source files only
    e) by compiling all source files before they get loaded plus
       compiling and loading all optional systems (installation option)

    Type a, b, c, d or e: ")

  ;; Reset options (might be set from previous runs):
  (setq *sneps-make-option* :load)

  (case (read *terminal-io*)
    (a (format t "~2%  Loading SNePS...~2%")
       (setq *sneps-make-option* :load))
    (b (format t "~2%  Changed source files will be compiled ~
                       before they are loaded....~2%")
       (setq *sneps-make-option* :compile))
    (c (format t "~2%  All source files will be compiled ~
                       before they are loaded....~2%")
       (setq *sneps-make-option* :recompile))
    (d (format t "~2%  All source files will be loaded uncompiled....~2%")
       (setq *sneps-make-option* :load-uncompiled))
    (e (format t "~2%  Compiling and loading SNePS and all ~
                       optional systems....~2%")
       (setq *sneps-make-option* :install))
    (t (format t "~2%  Loading SNePS....~2%")))
  )

(unless *sneps-noquery*
  (sneps-startup-query))

;; Logical Pathnames:

;; Boot the logical pathname system.  This is the only place where we have
;; to use physical pathnames in compile/load statements.  From here on
;; logical pathnames can be used in most Common-Lisp and SNePS commands that
;; take files as parameters (e.g., `open', `compile-file', `demo', etc.).
;; See the file `logical-pathnames.lisp' or refer to Guy Steele's
;; "Common Lisp: The Language" (2nd Edition), section 23.1.5 "Logical
;; Pathnames" for more information on logical pathnames.

;; Using logical pathnames is slightly complicated by the fact that not
;; all Lisps already provide an implementation for them. In case they
;; do not we use Mark Kantrowitz's implementation, but we have to make
;; some effort that that does not interfere with native implementations:

(if *sneps-use-lpmk*
    (pushnew :lpmk *features*))

;; We'll create this package regardless of whether we use a native
;; implementation of logical pathnames or not. Since this package
;; uses the LISP package, all logical pathname functions can be called
;; by qualifying them uniformly with `lp::' without having to worry
;; about what implementation is actually used.
(unless (find-package 'LOGICAL-PATHNAME)
  (make-package 'LOGICAL-PATHNAME :nicknames '("LP") :use '("LISP")))

(defun sneps-make-pathname (path name type &optional wild-inferiors)
  ;; Boot function for use until logical-pathnames are up and running.
  (format nil
	  #+mswindows
          "~a~:[~;\\**~]\\~@[~a~]~@[.~a~]"
          #+(or unix lm-unix)
	  "~a~:[~;/**~]/~@[~a~]~@[.~a~]"
	  #+(and explorer (not lm-unix))
	  "~a~:[~;.**~];~@[~a~]~@[.~a~]"
	  #+(and symbolics (not lm-unix))
	  "~a~:[~;>**~]>~@[~a~]~@[.~a~]"
	  #+vms
	  "~a~:[~;...~]]~@[~a~]~@[.~a~]"
	  #+apple
	  "~a~:[~;:**~]:~@[~a~]~@[.~a~]"
	  path
	  wild-inferiors
	  (and (stringp name) (not (string-equal name "")) name)
	  (and (stringp type) (not (string-equal type "")) type)
	  type))

(defun sneps-load0 (file)
  ;; Boot function for use until system-utils are up and running.
  (let ((*load-verbose* *sneps-verbose*)
	#+allegro
	(excl::*enable-package-locked-errors* nil)
	#+allegro
	(*redefinition-warnings* *sneps-verbose*)
	#+lucid
	(*redefinition-action* *sneps-verbose*)
	#+(or explorer symbolics)
        (si:inhibit-fdefine-warnings t))
    (load file)))

(defun sneps-compile-load0 (file)
  ;; Boot function for use until system-utils are up and running.
  (let ((source-pathname
         (sneps-make-pathname
          *sneps-directory* file *sneps-lisp-extension*))
        (load-pathname
         (sneps-make-pathname *sneps-directory* file "")))
    (if (member *sneps-make-option* '(:recompile))
        (compile-file source-pathname))
    (if (member *sneps-make-option* '(:install))
       	(compile-file source-pathname))
    (if (eq *sneps-make-option* :load-uncompiled)
        (sneps-load0 source-pathname)
      (sneps-load0 load-pathname))))


;;; altered by flj on 2/12/04 to make sneps run faster
(if *sneps-compiler-optimization-settings*
     (cond ((member *sneps-make-option* '(:compile :recompile))
	    (proclaim *sneps-compiler-optimization-settings*))
	   ((member *sneps-make-option* '(:install))
	    (proclaim *fast-sneps-compiler-optimization-settings*))))




#+lpmk
(sneps-compile-load0 "logical-pathnames")

(defvar *sneps-logical-pathname-translations*
    `(;; User translations first:
      ,@*sneps-user-translations*
;;; the next two lines are commented out for clisp compatibility (by FLJ 9/2/02)
;;;   ... because no load-before.lisp or other file exists      
;;;      ("before-sneps-load-hook" "sneps:load-before.LISP")  
;;;      ("after-sneps-load-hook" "sneps:load-after.LISP")
      ("snactor" "sneps:demo;snactor;load-snactor.LISP")
      ;; Even though `LISP' is a canonical type for Lisp source files
      ;; (CLtL-II, p.630), we have to explictly map it, since ACL 4.2
      ;; does not translate it into `lisp' the way it should.
      ("**;*.LISP" ,(sneps-make-pathname
		     *sneps-directory* "*" *sneps-lisp-extension* t))
      ("*.LISP" ,(sneps-make-pathname
		  *sneps-directory* "*" *sneps-lisp-extension* nil))
      ,@(if *sneps-binary-extension*
            `(("**;*.FASL" ,(sneps-make-pathname
			     *sneps-directory* "*"
			     *sneps-binary-extension* t))
              ("*.FASL" ,(sneps-make-pathname
			  *sneps-directory* "*"
			  *sneps-binary-extension* nil))))
      ;; CLISP (4/4/95) is very picky about exactly matching wildcards
      ;; between LHS and RHS.  It also needs to have every variation that
      ;; has an empty component (e.g., missing type) listed separately:
      ("**;*.*" ,(sneps-make-pathname *sneps-directory* "*" "*" t))
      ("**;*" ,(sneps-make-pathname *sneps-directory* "*" nil t))
      ("*.*" ,(sneps-make-pathname *sneps-directory* "*" "*" nil))
      ("*" ,(sneps-make-pathname *sneps-directory* "*" nil nil))))

(defvar *sneps-garnet-translations*
    `(("**;*.LISP" ,(sneps-make-pathname
                     *sneps-garnet-directory* "*"
                     *sneps-garnet-lisp-extension*
                     t))
      ("*.LISP" ,(sneps-make-pathname
                  *sneps-garnet-directory* "*"
                  *sneps-garnet-lisp-extension*
                  nil))
      ("**;*.*" ,(sneps-make-pathname *sneps-garnet-directory* "*" "*" t))
      ("**;*" ,(sneps-make-pathname *sneps-garnet-directory* "*" nil t))
      ("*.*" ,(sneps-make-pathname *sneps-garnet-directory* "*" "*" nil))
      ("*" ,(sneps-make-pathname *sneps-garnet-directory* "*" nil nil))))

(defvar *sneps-patch-translations*
  `(("**;*.*" ,(sneps-make-pathname *sneps-patch-directory* "*" "*" t))
    ("**;*" ,(sneps-make-pathname *sneps-patch-directory* "*" nil t))
    ("*.*" ,(sneps-make-pathname *sneps-patch-directory* "*" "*" nil))
    ("*" ,(sneps-make-pathname *sneps-patch-directory* "*" nil nil))))


(defvar *sneps-logical-hosts* '("sneps" "garnet" "sneps-p" "sneps21")
  "List of logical hosts recognized by SNePS.
Only namestrings starting with these hosts will be classified
as namestrings of logical pathnames.")


;; Load a file that actually installs these translations in the
;; logical pathname package.  This is a separate file so that the acl
;; standalone can also reestablish the translations (which, starting
;; with version 4.3 are thrown away when a dumped image restarts.)
(load (format nil "~A/load-logical-pathnames.~A" *sneps-directory* *sneps-default-lisp-extension*))


;; End of Logical Pathnames

;; Load simple system utilities; after that we have a proper
;; version of `sneps-load' which understands logical pathnames:
(sneps-compile-load0 "system-utils")

;;; commented out by FLJ 9/2/02
;;;;; Load before hook file if it exists:
;;;(if (sneps-probe-file "sneps:before-sneps-load-hook")
;;;    (sneps-load "sneps:before-sneps-load-hook"))

;; Compile/load SNePS:
(cond ((eq *sneps-make-option* :install)
       (setq *sneps-make-option* :recompile)
       (sneps-load "sneps:system.LISP")
       (dolist (system *sneps-optional-systems*)
	 (sneps-load system)))
      (t (sneps-load "sneps:system.LISP")))

(defun sneps ()
  (let ((*package* (find-package 'snepsul)))
    (sneps:sneps)))

(defun snepslog (&rest args)
  (apply #'sneps:snepslog args))

;;; commented out by FLJ 9/2/02
;;;;; Load after hook file if it exists:
;;;(if (sneps-probe-file "sneps:after-sneps-load-hook")
;;;    (sneps-load "sneps:after-sneps-load-hook"))

#+(and allegro-version>= (version>= 6 0))
(progn
  (setf *print-case* *pre-sneps-load-print-case-mode*)
  (cond ((equal *pre-sneps-load-case-mode* :case-sensitive-lower)
	 (excl:set-case-mode :case-sensitive-lower)
	 (excl::convert-mixed-case-symbols nil))))


(format t "~&~a loaded.~
           ~%Type `(sneps)' or `(snepslog)' to get started."
	*sneps-version*)




    
    




