;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: MATCH; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: mbind.lisp,v 1.6 2004/08/26 23:25:09 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :match)


;;; -----------------------------------------------------------------------------
;;;       Ported from Franz Lisp to Common Lisp:   KEB  Summer 1987
;;; -----------------------------------------------------------------------------
;;;
;;;
;;;
;;; =============================================================================
;;; Data Type:  <mbind> ::= (<mvar> . <mnode>)
;;;
;;;***************************
;;;   Changed to: <mbind> ::= (<key> . <node>)  {as an element of a LISP A-List}
;;;
;;; ============================================================================
;;;
;;; new.mb
;;; ------
;;;
;;;       arguments     : mv - <mvar> 
;;;                       mn - <mnode>
;;;
;;;       returns       : <mbind>
;;;
;;;       description   : Creates a <new mbind> from 'mv' and 'mn'.
;;;
;;;                                  written:  vhs 11/19/84
;;;                                  modified:
;;;
;;; Definition moved to: match/ds/mnoderepset  so that it will be available when
;;;            it is used.
;;;
;;;(defmacro new.mb (mv mn)
;;;  "Creates a <new mbind> from 'mv' and 'mn'."
;;;   `(cons ,mv ,mn))
;;;
;;;
;;; =============================================================================
;;;
;;; is.mb
;;; -----
;;;
;;;       arguments      : u - <universal>
;;;
;;;       returns        : <boolean>
;;;
;;;       description    : returns 'true' if 'u' is a <mbind>, 'false' otherwise.
;;;
;;;
;;;                                  written:  vhs 11/19/84
;;;                                  modified: ssc 11/23/88
;;;
;;;
#|
(defmacro is.mb (u)
  "Returns 'true' if 'u' is a <mbind>, 'false' otherwise."
   `(and (consp ,u)     
         (or (is.n (car ,u))
	     (ispat.n (car ,u)))
         (is.n (cdr ,u))))
|#
;;;
;;;
;;; =============================================================================
;;;
;;; mvar.mb
;;; -------
;;;
;;;        arguments      : mbind -  <mbind>
;;; 
;;;        returns        : <mvar> 
;;; 
;;;        description    : returns the <mvar> of 'mbind'.
;;;
;;;                                  written:  vhs 11/19/84
;;;                                  modified:
;;;
;;;
(defun mvar.mb (mbind)
  "Returns the <mvar> of 'mbind'."
   (car mbind))
;;;
;;;
;;; =============================================================================
;;;
;;; mnode.mb
;;; --------
;;;
;;;        arguments       : mbind - <mbind> 
;;;          
;;;        returns         : <mnode>
;;; 
;;;        description     : returns the <mnode> of 'mbind'.
;;;                             
;;;
;;;                                  written:  vhs 11/19/84
;;;                                  modified:
;;;
(defun mnode.mb (mbind)
  "Returns the <mnode> of 'mbind'."
   (cdr mbind))
;;;
;;;
;;; =============================================================================
;;;
;;; compose.mb
;;; ----------
;;;
;;;       arguments     : mb - <mbind>
;;;                       sub - <substitution>
;;;
;;;       returns       : <mbind> 
;;;
;;;       nonlocal-vars : *INITSUB*
;;;
;;;       description   : It is used to construct the <source substitution>.
;;;                       'mb' is an <mbind> from *RENAMESUB*.  sub is *SUB*.
;;;                       Only <mbind>s whose <mvar> is a <node> are included.
;;;                       It returns an <mbind> with that <mvar> and the 
;;;                       appropriate instance of the <mnode> of 'mb'.
;;;                       In case the <mnode> is changed, *FINALMNRS* is updated.
;;;
;;;       side-effects  : *FINALMNRS*  
;;;
;;;                                        written :  vhs 04/25/85
;;;                                        modified:
;;;
;;;
#|
(defun compose.mb (mb sub)
  "It is used to construct the <source substitution>.
   'mb' is an <mbind> from *RENAMESUB*.  sub is *SUB*.
   Only <mbind>s whose <mvar> is a <node> are included.
   It returns an <mbind> with that <mvar> and the 
   appropriate instance of the <mnode> of 'mb'.
   In case the <mnode> is changed, *FINALMNRS* is updated."
  (let ((*node* (mvar.mb mb))
        (value (mnode.mb mb))
        (all-psym nil)
        (new-msym nil))
    (declare (special *node*))
    (declare (special *RENAMESUB* *FINALMNRS* *INITSUB* *SUB* *CHANGED*))
    (cond ((is.n *node*)
	   (cond ((isbound.sbst value sub)
		  (makeone.set (new.mb *node* (target-instance.n (mnode.sbst value sub)))))
		 ((isbound.sbst value *RENAMESUB*)
		  (makeone.set (new.mb *node* (mnode.sbst value *RENAMESUB*)))) 
		 ((isvar.n *node*)
		  (cond ((is.xsym value) (update.mnrs '*FINALMNRS* value *node* *FINALMNRS*) nil)
			((is.usym value)
			 (cond ((changed.mv value) 
				(setq new-msym (new.usym))
				(rename-mnoderep.mnrs value new-msym *FINALMNRS*)
				(makeone.set (new.mb *node* new-msym)))
			       (t (let ((old-usym (mnode.sbst *node* *INITSUB*)))
				    (put-back.mnrs value old-usym *FINALMNRS*)
				    (update.sbst '*SUB* value old-usym *SUB*)
				    (makeone.set (new.mb *node* old-usym))))))
			((is.isym value)
			 (cond
			  ((changed.mv value) 
			   (setq new-msym (new.isym))
			   (rename-mnoderep.mnrs value new-msym *FINALMNRS*)
			   (makeone.set (new.mb *node* new-msym)))
			  ((is.isym (mnode.sbst *node* *INITSUB*)) 
			   (let ((old-isym (mnode.sbst *node* *INITSUB*)))
			     (update.sbst '*SUB* value old-isym *SUB*)
			     (put-back.mnrs value old-isym *FINALMNRS*)
			     (adjoin.mns '*CHANGED* old-isym *CHANGED*)
			     (makeone.set (new.mb *node* old-isym))))
			  (t (let ((p-bind (mnode.sbst *node* *INITSUB*)))
			       (update.sbst '*SUB* value p-bind *SUB*)
			       (update.mnrs '*FINALMNRS* value p-bind *FINALMNRS*)
			       (makeone.set (new.mb *node* p-bind))))))
			(t (makeone.set mb))))
		 ((ispat.n *node*) 
		  (cond ((is.usym value)
			 (cond ((changed.mv value)
				(setq new-msym (new.usym))
				(rename-mnoderep.mnrs value new-msym *FINALMNRS*)
				(makeone.set (new.mb *node* new-msym)))
			       (t (let ((old-usym (mnode.sbst *node* *INITSUB*)))
				    (update.sbst '*SUB* value *node* *SUB*)
				    (put-back.mnrs value old-usym *FINALMNRS*)
				    (makeone.set (new.mb *node* old-usym))))))
			((is.isym value)
			 (cond
			  ((changed.mv value) 
			   (setq new-msym (new.isym))
			   (rename-mnoderep.mnrs value new-msym *FINALMNRS*)
			   (makeone.set (new.mb *node* new-msym)))
			  (t (update.sbst '*SUB* value *node* *SUB*)
			     (update.mnrs '*FINALMNRS* value *node* *FINALMNRS*) 
			     nil)))
			(t (makeone.set mb))))))
	  (t nil))))
|#
;;;
;;;
;;; =============================================================================
;;;
;;; target.mb
;;; ---------
;;;
;;;       arguments     : mb - <mbind>
;;;
;;;       returns       : (<mb>) | nil 
;;;
;;;       nonlocal-vars : *CHANGED* *INITSUB*
;;;
;;;       description   : It constructs an <mbind> for the <target substitution>.
;;;                       'mb' comes from *SUB* and is considered only if its
;;;                       <mvar> is a <node>.  The function compose.mb.mn insures
;;;                       that the right instance of the <mnode> of the <mbind>
;;;                       is used.
;;;
;;;                                        written :  vhs 04/25/85
;;;                                        modified:
;;;
;;;
#|
(defun target.mb (mb)

  "It constructs an <mbind> for the <target substitution>.
   'mb' comes from *SUB* and is considered only if its
   <mvar> is a <node>.  The function compose.mb.mn insures
   that the right instance of the <mnode> of the <mbind>
   is used."

  (cond ((is.n (mvar.mb mb))
         (makeone.set mb))
        (t nil)))
|#
;;;
;;;     
;;; =============================================================================
;;;
;;; iseq.mb
;;; -------
;;;
;;;       arguments     : mbind1 - <mbind>
;;;                       mbind2 - <mbind>
;;;
;;;       returns       : <boolean>
;;;  
;;;       description   : Compares 'mbind1' and 'mbind2' as <mbind>s : 
;;;                       returns 'true' if 'mbind1' and 'mbind2' have the
;;;                       same <mvar> and the same <mnode>, 'false' otherwise.
;;;
;;;                                  written:  vhs 11/19/84
;;;                                  modified:
;;;
(defmacro iseq.mb (mbind1 mbind2)

   "Compares 'mbind1' and 'mbind2' as <mbind>s : 
    returns 'true' if 'mbind1' and 'mbind2' have the
    same <mvar> and the same <mnode>, 'false' otherwise."

   `(and (eq  (mvar.mb mbind1) (mvar.mb mbind2))
         (iseq.mn (mnode.mb ,mbind1) (mnode.mb ,mbind2))))       
;;;
;;;   
;;; =============================================================================



    
    




