;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: MATCH; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: supmatching.lisp,v 1.6 2004/08/26 23:25:09 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :match)


;;; -----------------------------------------------------------------------------
;;;       Ported from Franz Lisp to Common Lisp:   KEB  Summer 1987
;;; -----------------------------------------------------------------------------
;;;
;;;
;;; =============================================================================
;;; Data Type:  <supmatching> ::= (<target node> <target substitution>
;;;                                <target support> <source substitution>)
;;;
;;; =============================================================================
;;;
;;; make.supmatching
;;; ----------------
;;;
;;;       arguments     : tnode - <target node>
;;;                       srcsub - <source substitution>
;;;                       tsub - <target substitution>
;;;                        
;;;       returns       : <matching> 
;;;
;;;       description   : makes a <matching> from 'tnode', 'srcsub', and 'tsub'
;;;
;;;                                        written :  cpf/njm 10/19/88
;;;                                        modified:  
;;;
;;;
(defmacro make.supmatching (tnode  tsub tsup srcsub)
  "Makes a <matching> from 'tnode', 'tsub', 'tsup' and 'srcsub'."
  `(list ,tnode ,tsub ,tsup ,srcsub))
;;;
;;;
;;; =============================================================================
;;;
;;; tnode.supmatching
;;; --------------
;;;
;;;       arguments     : supmatching - <supmatching> 
;;;
;;;       returns       : <node> 
;;;
;;;       description   : returns the <tnode> of 'supmatching'
;;;
;;;                                        written :  cpf/njm 10/19/88
;;;                                        modified:
;;;
;;;
(defmacro tnode.supmatching (supmatching)
  "Returns the <tnode> of 'supmatching'."
  `(first ,supmatching))
;;;
;;;
;;; =============================================================================
;;;
;;; source-sub.supmatching
;;; -------------------
;;;
;;;       arguments     : supmatching - <supmatching> 
;;;
;;;       returns       : <source substitution> 
;;;
;;;       description   : returns the <source substitution> of 'supmatching'. 
;;;
;;;                                        written :  cpf/njm 10/19/88
;;;                                        modified:  
;;;
;;;
(defmacro source-sub.supmatching (supmatching)
  "Returns the <source substitution> of 'supmatching'."
  `(fourth ,supmatching))
;;;
;;;
;;; =============================================================================
;;;
;;; target-sub.supmatching
;;; -------------------
;;;
;;;       arguments     : supmatching - <supmatching>
;;;
;;;       returns       : <target substitution> 
;;;
;;;       description   : returns the <target substitution> of 'supmatching'. 
;;;
;;;                                        written :  cpf/njm 10/19/88
;;;                                        modified:
;;;
;;;
(defmacro target-sub.supmatching (supmatching)
  "Returns the <target substitution> of 'supmatching'."
  `(second ,supmatching))
;;;
;;; ==========================================================================
;;;
;;; target-sup.supmatching
;;; ----------------------
;;;
;;;       arguments     : supmatching - <supmatching>
;;;
;;;       returns       : <target substitution> 
;;;
;;;       description   : returns the <target substitution> of 'supmatching'. 
;;;
;;;                                        written :  cpf/njm 10/19/88
;;;                                        modified:  
;;;
;;;
(defmacro target-sup.supmatching (supmatching)
  "Returns the <target substitution> of 'supmatching'."
  `(third ,supmatching))
;;;
;;; ==========================================================================



    
    




