;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: PARSER; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: exports.lisp,v 1.7 2004/08/26 23:25:30 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :parser)


;;;   Export the following symbols from the PARSER package.

(export 's)                   ; "S" is the start state of the parser.

(export '(*config* *trace-level* *parse-trees* *all-parses*
	  *terminating-punctuation-flag*
          *punct-chars* *white-space* *quote-chars* *escape-chars*
	  break-arc unbreak-arc
	  *input-redirect-stream* *lexentry* *atn-arcs-hashtable*
	  setr getr sendr liftr current-configuration packageless-equal
	  buildq lexin parse atnin talk getarcs putarc  geta addr
	  overlap disjoint nullr endofsentence addl flatten parser-print
	  atnreadln convertline list-to-type
	  hold to jump cat vir wrd rcall call tst group push pop lex I understand
	  that))

(import '( *trace-level* putarc getarcs overlap disjoint
	  endofsentence buildq pconcat
	  geta addr addl setr sendr liftr getr nullr
	  hold to jump cat vir wrd rcall tst group
	  atnin definenet parse lex I understand that
 	  break-arc unbreak-arc current-configuration
	  *all-parses* *parse-trees* *terminating-punctuation-flag*
          *punct-chars* *white-space* *quote-chars* *escape-chars*
	  packageless-equal)
	(find-package 'snepsul))

(shadowing-import '(call getf push pop) (find-package 'snepsul))



    
    




