;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: cable.lisp,v 1.6 2004/08/26 23:25:40 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


; =============================================================================
; Data Type:  <cable> ::= (<relation> . <node set>)     
; =============================================================================
;
; 
; =============================================================================
;
; new.c
; -----
;
;       arguments     : r - <relation>
;                       ns - <node set>
;
;       returns       : <cable>
;
;       description   : Creates a <newcable> from "r" and "ns".
;
;                                        written : rmo 07/28/63
;                                        modified:
;
;
(defmacro new.c (r ns)
   `(cons ,r ,ns))
;
;
; =============================================================================
;
; is.c
; ----
;
;       arguments     : u - <universal> 
;
;       returns       : <boolean>
;
;       description   : returns "true" if it is a <cable>, "false"
;                       otherwise. 
;
;                                        written : rmo 07/28/83
;                                        modified:
;
;
(defmacro is.c (u)
   `(and (consp ,u)
         (is.r (car ,u))
         (is.ns (cdr ,u))))
;
; =============================================================================
;
; update.c 
; --------
;
;       arguments     : ns - <node set>
;                       c - <cable>
;
;       returns       : <cable>
;
;       description   : returns a <cable> with the same <relation> of "c"
;                       and with a <node set> which is the union of "ns" with
;                       the <node set> of "c".
;
;                                        written : rmo 07/28/83
;                                        modified:
;
;
(defmacro update.c (ns c)
   `(cons (car ,c)
          (union.ns (cdr ,c) ,ns)))
;
;
; =============================================================================
;
; relation.c 
; ----------
;
;       arguments     : c - <cable>
;
;       returns       : <relation>       
;
;       description   : Returns the <relation> of "c".
;
;                                        written : rmo 07/28/83
;                                        modified:
;
;
(defmacro relation.c (c)
   `(car ,c))
;
;
; =============================================================================
;
; nodeset.c 
; ---------
;
;       arguments     : c - <cable>
;
;       returns       : <node set> 
;
;       description   : returns the <node set> of "c".
;
;                                        written : rmo 07/28/83
;                                        modified:
;
;
(defmacro nodeset.c (c)
   `(cdr ,c))
;
;
; =============================================================================
;
; iseq.c
; ------
;
;       arguments     : c1 - <cable>
;                       c2 - <cable>
;
;       returns       : <boolean>
;
;       description   : Returns "true" if "c1" and "c2" are equal as <cable>s,
;                       that is, if they have the same <relation> and the same
;                       nodeset, "false" otherwise.
;
;                                        written : rmo 07/28/83
;                                        modified: ejm 08/30/83
;
;
(defmacro iseq.c (c1 c2)
   `(and (iseq.r (relation.c ,c1) (relation.c ,c2))
         (iseq.ns (nodeset.c ,c1) (nodeset.c ,c2))))
;
;
; =============================================================================
;
; describe.c
; ----------
;
;       arguments     : c - <cable>
;
;       returns       : <dotted pair>
;
;       description   : It returns a <dotted pair> which is a description of 
;                       the <cable> "c" to be printed.
;
;                                        written :  ejm 06/05/84
;                                        modified:
;
(defmacro describe.c (c)
   `(cons (describe.r  (relation.c ,c))
          (describe.ns (nodeset.c ,c))))
;
;
; =============================================================================

 
;;;
;;;  Functions used in Match
;;;
;;;
;;; =============================================================================
;;;
;;; rename.c
;;; --------
;;;
;;;       arguments     : c - <cable> 
;;;
;;;       returns       : <mcable> 
;;;
;;;       description   : renames the <node>s in the <node set> of 'c' 
;;;
;;;       side-effects  : *RENAMESUB*, *MNRS* 
;;;
;;;                                        written :  vhs 06/17/85
;;;                                        modified:
;;;
;;;
#|
(defmacro rename.c (c)

   "Renames the <node>s in the <node set> of 'c'."

  `(new.mc (relation.mc ,c) (rename.ns (nodeset.c ,c))))
|#
;;;
;;;
;;; =============================================================================
;;;
;;; changed.c
;;; ---------
;;;
;;;       arguments     : c - <cable> 
;;;
;;;       returns       : <boolean> 
;;;
;;;       description   : returns true if any <node> in 'c' is bound in *SUB*,
;;;                       or dominates a <node> which is bound, 'false' ow.
;;;
;;;                                        written :  vhs 06/17/85
;;;                                        modified:
;;;
;;;
#|
(defun changed.c (c)
   "Returns true if any <node> in 'c' is bound in *SUB*,
    or dominates a <node> which is bound, 'false' ow."
  (changed.ns (nodeset.c c)))
|#
;;;
;;;
;;; =============================================================================
;;;
;;; all-instances.c
;;; ---------------
;;;
;;;       arguments     : c - <cable> 
;;;
;;;       description   : Finds all <pattern node>s in 'c' which dominate
;;;                       variables bound in *SUB*, and binds them to their
;;;                       instances.
;;;
;;;       side-effects  : *FINAL-TARGET-SUB*, *CHANGED*, *FINALMNRS*
;;;
;;;                                        written :  vhs 06/17/85
;;;                                        modified:
;;;
;;;
#|
(defun all-instances.c (c)
  "Finds all <pattern node>s in 'c' which dominate
   variables bound in *SUB*, and binds them to their instances."
  (mapc
   (function
    (lambda (n) (match::add-instance.n n)))
   (nodeset.c c)))
|#
;;;
;;;
;;; =============================================================================



    
    




