;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: rel1.lisp,v 1.8 2004/08/26 23:25:42 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


; =============================================================================
; Data Type:  <relation>
; =============================================================================
;
; 
; =============================================================================
;
; is.r         
; ----
;
;       arguments     : u - <universal>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "u" is a <relation>, otherwise
;                       "false".
;
;                                        written:  mja 07/28/83
;                                        modified: ejm 06/05/84
;                                        modified: scs 12/31/87 acc to scottlog
;
;
(defmacro is.r (u)
  `(if (symbolp ,u) (get ,u '=conv)))
;
;
; =============================================================================
;
; iseq.r
; ------
;
;       arguments     : r1 - <relation>
;                       r2 - <relation>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "r1" and "r2" are the same
;                       <relation>, "false" otherwise.
;
;                                        written:  ejm 08/19/83
;                                        modified:
;
;
(defmacro iseq.r (r1 r2)
   `(eq ,r1 ,r2))
;
;
; =============================================================================
;
; describe.r
; ----------
;
;       arguments     : r - <relation>
;
;       returns       : <atom>
;
;       description   : It returns an  <atom> which is a description of
;                       the  <relation> "r" to be printed.
;                       The description is identical to "r".
;
;                                        written :  ejm 06/05/84
;                                        modified:
;
(defmacro describe.r (r)
   `,r)
;
;
; =============================================================================



    
    




