;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: snd.lisp,v 1.6 2004/08/26 23:25:42 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


; =============================================================================
; Data Type:  <snepsul node description> ::=
;                   ( <relation form> <nodeset form> 
;                                  . . .
;                     <relation form> <nodeset form> )
; =============================================================================
;
;
; =============================================================================
;
; isnew.snd
; ---------
;
;       arguments     :  snd - <snepsul node description>
;
;       returns       :  <boolean>
;
;       description   :  Returns t if "snd" is a new <snepsul node 
;                        description>, nil otherwise.
;
;       implementation: 
;
;                                        written :  jms 9/20/83
;                                        modified:
;
;
(defmacro isnew.snd (snd)
   `(null ,snd))
;
;
; =============================================================================
;
; nodesetform.snd
; ---------------
;
;       arguments     : snd - <snepsul node description>
;                             Assumed to be represented as a list.
;
;       returns       : <nodeset form>
;
;       description   :   It returns the first <nodeset form> from snd.
;                         But first, if the first <nodeset form> in snd is followed by
;                         a postfix operator (!) or an infix operator, snd is changed
;                         by side-effect to incorporate the Cambridge Prefix version
;                         into the first <nodeset form>.
;
;       side-effects  : The <snepsul node description> which is the value of snd.
;
;                                        written :  jms 9/20/83
;                                        modified:  scs 2/24/87
;
;
(defun nodesetform.snd (snd)
  (loop
    (cond ((eq (third snd) '!)
	   (setf (cdr snd)
		 (cons (list '! (second snd)) (cdddr snd))))
	  ((isrearrange.com (third snd))
	   (cond ((fourth snd)
		  (setf (cdr snd)
			(cons (list (third snd) (second snd) (fourth snd)) (cddddr snd))))
		 (t (sneps-error (format nil
					 "Infix operator missing second operand: ~A"
					 (cddr snd))
				 '|Evaluation of node description|
				 'nodesetform.snd))))
	  (t (return (second snd))))))
;
;
; =============================================================================
;
; relationform.snd
; ----------------
;
;       arguments     : snd - <snepsul node description>
;
;       returns       :  <relation form>
;
;       description   :   It returns the first <relation form> from snd.
;
;                                        written :  jms 9/20/83
;                                        modified:
;
;
(defmacro relationform.snd (snd)
   `(first ,snd))
;
;
; =============================================================================
;
; rest.snd
; --------
;
;       arguments     : snd - <snepsul node description>
;
;       returns       : <snepsul node description>
;
;       description   :   It returns snd without its first <relation> -
;                       <nodeset form> pair.
;
;                                        written :  jms 9/20/83
;                                        modified:
;
;
 
(defmacro rest.snd (snd)
   `(rest (rest ,snd)))
;
; =============================================================================



    
    




