;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: restr.lisp,v 1.7 2004/08/26 23:25:47 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


; ==============================================================================
; addrestr
; --------
;
;        arguments     : r - <context set> 
;                        c - <context>
;
;        returns       : <context>
;
;        description   : It adds the context "r" to the restriction slot of 
;                        context "c".
;
;
;                                        written :  njm  09/14/88 
;                                        modified:
;
;
(defmacro addrestr (r c)
  "It adds the context 'r' to the restriction slot of context 'c'.
   Returns the context 'c'."   
  `(prog2 (setf (context-restriction ,c)
                (sigma (union.cts ,r (context-restriction ,c))))
	  ,c))

;
; =============================================================================
;                               DEITAR FORA ?
;
;
; newrestriction  
; --------------
;
;
;       arguments     : hyps - <node set>
;
;       returns       : <context set>
;
;       description   : Computes the restriction associated with a recently
;                       created context defined by the assertions 'hyps'.
;                       Returns the computed restriction set.
;
;       
;
;
;                                  written :  jpm 12/02/82 
;                                  modified:  njm 10/06/88
;
;
;
;(defun newrestriction (hyps) 
;  (if (null hyps)
;      nil
;      (sigma (psi (apply
;		    #'append
;		    (mapcar #'(lambda (n)
;				(context-restriction (exists.ct (list n))))
;			    hyps))
;		  (exists.ct hyps)))))
;




;
; =============================================================================
;
;
; psi  
; ---
;
;
;       arguments     : fullrs - <context set>
;                       ct     - <context>
;
;       returns       : <context set>
;
;       description   : Implements the psi function of the SWM logic.
;                       'fullrs' is the union of all the restrictions
;                       associated with the contexts defined by each 
;                       single hypothesis of 'ct'.
;       
;
;
;                                  written :  jpm 12/02/82 
;                                  modified:  njm 10/06/88
;
;
;
(defun psi (fullrs ct)
  (cond ((isnew.cts fullrs) (new.cts))
	((issubset.ct (choose.cts fullrs) ct)
	 (makeone.cts (getcontext (new.ns))))
	((isdisjoin (choose.cts fullrs) ct)
	 (insert.cts (choose.cts fullrs) (psi (others.cts fullrs) ct)))	
	(t (insert.cts
	     (fullbuildcontext (compl.ns (context-hyps (choose.cts fullrs))
					 (context-hyps ct))
			       (new.cts))
	     (psi (others.cts fullrs) ct)))))



;
; =============================================================================
;
;
; sigma  
; -----
;
;
;       arguments     : ctset - <context set>
;
;       returns       : <context set>
;
;       description   : Implements the sigma function of the SWM logic.
;
;       
;
;
;                                  written :  jpm 12/02/82 
;                                  modified:  njm 10/06/88
;
;
;
(defun sigma (ctset)
  (let ((empty (getcontext (new.ns))))
    (if (ismemb.cts empty ctset)
	(makeone.cts empty)
	(sigma-1 ctset ctset))))


(defun sigma-1 (wset oset)
  (cond ((isnew.cts wset) (new.cts))
	((existsubset (choose.cts wset) oset)
	 (sigma-1 (others.cts wset) oset))
	(t (insert.cts (choose.cts wset) (sigma-1 (others.cts wset) oset)))))


;
; =============================================================================
;
;
; existsubset  
; -----------
;
;
;       arguments     : c  - <context>
;                       cs - <context set>
;
;       returns       : <boolean>
;
;       description   : Returns T if 'c' is a superset of any context
;                       present in 'cs', NIL otherwise.
;
;       
;
;
;                                  written :  jpm 12/02/82 
;                                  modified:  njm 10/06/88
;
;
;
(defun existsubset (c cs)
  (cond ((isnew.cts cs) nil)
	((and (issubset.ct (choose.cts cs) c)
	      (not (iseq.ct c (choose.cts cs)))) t)
	(t (existsubset c (others.cts cs)))))


;
; =============================================================================
;
;
; isdisjoin  
; ---------
;
;
;       arguments     : c1 - <context>
;                       c2 - <context>
;
;       returns       : <boolean>
;
;       description   : Returns T if 'c1' and 'c2' have not any hypothesis in
;                       common, NIL otherwise.
;
;       
;
;
;                                  written :  jpm 12/02/82 
;                                  modified:  njm 10/06/88
;
;
;


(defun isdisjoin (c1 c2)
  (isnew.cts (intersect.ns (context-hyps c1) (context-hyps c2))))


;
; =============================================================================
;
;
; updateall  
; ---------
;
;
;       arguments     : ct - <context>
;
;       returns       : ???
;
;       description   : 'ct' is an inconsistent context. This function upadtes
;                       the restriction sets of all contexts with this information.
;
;       
;
;
;                                  written :  mrc 10/20/88 
;
;
;
(defun updateall (ct)
  (updateall-1 ct (allct)))

(defun updateall-1 (ct cts)
  (cond ((isnew.cts cts) t)
	((isdisjoin ct (choose.cts cts)) (addrestr (makeone.cts ct) (choose.cts cts))
					 (updateall-1 ct (others.cts cts)))
	(t (updateall-1 ct (others.cts cts)))))



    
    




