;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: tconc.lisp,v 1.6 2004/08/26 23:25:47 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


(defstruct tconc car cdr)

(defun tconc (tconc-cell s-exp)
  (prog ((list-s-exp (list s-exp)))
    (cond ((eql tconc-cell nil)
 	   (setq tconc-cell (make-tconc :car list-s-exp
					:cdr list-s-exp)))
	  ((tconc-p tconc-cell)
	   (rplacd (tconc-cdr tconc-cell) list-s-exp)
	   (setf (tconc-cdr tconc-cell) list-s-exp))
	 (t (error "~a is not a tconc cell. ~%" tconc-cell))))
  tconc-cell)

(defun lconc (tconc-cell list)
   (cond ((eql tconc-cell nil)
	  (setq tconc-cell (make-tconc :car list
				       :cdr (last list))))
	 ((tconc-p tconc-cell)
	  (rplacd (tconc-cdr tconc-cell) list)
	  (setf (tconc-cdr tconc-cell) (last list)))
	 (t (error "~a is not a tconc cell. ~%" tconc-cell)))
   tconc-cell)



    
    




