;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPSLOG; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: snepslog.lisp,v 1.8 2004/08/26 23:25:51 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snepslog)


(defvar complete-description nil
  "This variable is used to select the mode (normal or expert) used to describe the nodes")

(defmacro surface (&rest nodes)
  `(snepslog-print ',nodes))

(defun slight-surface (node &optional (stream nil))
  "Prints in stream the representation of a node"
  (format stream "~A" (m->wff node)))
  
(defun node-intern (string)
  "Returns the node represented by string."
  (sneps:node (wff->m (intern string))))

;;; altered for acl6.X by FLJ... "WFF" -> the appropriate case for 
;;;    the current lisp version (using "build-namestring")
;;; allows input of wffs as "wff##" .vs "WFF##"
(defun sneps-node? (string)
  "given a string, returns t if the string represents the short name of a proposition"
  (and (stringp string)
       (string-equal string (build-namestring :wff) :start1 0 :end1 2 :start2 0 :end2 2)
       (parse-integer (subseq string 3) :junk-allowed t)))

(defun make.snepslog1 ()
  "changes the way snepslog relations are represented in sneps. Makes the arcs to the arguments not to be indexed on the predicate"
  ;; This is a new 'canonical' relation put onto sneps:*initial-relations*
  (define-if-not-yet-defined 'snepsul:r)
  (setf (get 'mode 'relation-argument.list) #'relation-argument.list_mode.1)
  (setf (get 'mode 'relation-predicate) #'relation-predicate_mode.1)
  (setf (get 'mode 'make-relation) #'make-relation.1))

(defun make.snepslog2 ()
  "changes the way snepslog relations are represented in sneps. Makes the arcs to the arguments be indexed on the predicate"
  (setf (get 'mode 'relation-argument.list) #'relation-argument.list_mode.2)
  (setf (get 'mode 'relation-predicate) #'relation-predicate_mode.2)
  (setf (get 'mode 'make-relation) #'make-relation.2))

(make.snepslog1)



    
    




