;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: destination.lisp,v 1.6 2004/08/26 23:26:07 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; <destination> ::=  <node> | 'USER
;
; -----------------------------------------------------------------------------
;
; RECOGNIZERS    is.dest      : <universal> --> <boolean>
;                iseq.dest    : <destination> x <destination> --> <boolean>
;                is-user.dest : <destination> --> <boolean>
;
; =============================================================================
;
; is.dest
; -------
;
;       arguments     : u - <universal>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "u" is a <destination>,
;                               "false" otherwise
;
;                                        written :  rgh  3/08/86
;                                        modified:
;
;
(defmacro is.dest (u)
  `(or (eq ,u 'USER) (is.n ,u)))
;
;
; =============================================================================
;
; iseq.dest
; ---------
;
;       arguments     : d1, d2 - <destination>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "d1" and "d2" are equivalent
;                       <destination>s, "false" otherwise
;
;                                        written :  rgh  3/22/86
;                                        modified:
;
;
(defmacro iseq.dest (d1 d2)
  `(or (and (eq ,d1 'USER) (eq ,d2 'USER))
       (and (is.n ,d1) (is.n ,d2) (iseq.n ,d1 ,d2))))
;
;
; =============================================================================
;
; is-user.dest
; ------------
;
;       arguments     : d - <destination>
;
;       returns       : <boolean>
;
;       description   : Returns "true" if "d" is 'USER, "false" otherwise
;
;                                        written :  rgh  3/08/86
;                                        modified:
;
;
(defmacro is-user.dest (d)
  `(eq ,d 'USER))
;
;
; =============================================================================



    
    




