;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: feederset.lisp,v 1.6 2004/08/26 23:26:07 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; <feeder set> ::= { <feeder> ... }
;
; -----------------------------------------------------------------------------
;
; PRIMITIVE      new.feedset : --> <feeder set>
;  ELEMENTS
;
; RECOGNIZERS    is.feedset    : <universal> --> <boolean>
;                isnew.feedset : <feeder set> --> <boolean>
;
; SELECTORS      choose.feedset : <feeder set> --> <feeder>
;                others.feedset : <feeder set> --> <feeder set>
;
; CONSTRUCTORS   insert.feedset : <feeder> x <feeder set> --> <feeder set>
;
; =============================================================================
;
; new.feedset
; -----------
;
;       returns       : <feeder set>
;
;       description   : returns a "new" <feeder set>
;
;                                        written :  rgh 08/21/85
;                                        modified:
;
;
(defmacro new.feedset ()
  `(new.Set))
;
;
; =============================================================================
;
; is.feedset
; ----------
;
;       arguments     : u - <universal>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "u" is a <feeder set>,
;                               "false" otherwise
;
;                                        written :  rgh 08/21/85
;                                        modified:
;
;
(defmacro is.feedset (u)
  `(and (is.Set ,u)
        (is.feeder (choose.Set ,u))))
;
;
; =============================================================================
;
; isnew.feedset
; -------------
;
;       arguments     : fs - <feeder set>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "fs" is a "new" <feeder set>
;                               "false" otherwise
;
;                                        written :  rgh 08/21/85
;                                        modified:
;
;
(defmacro isnew.feedset (fs)
  `(isnew.Set ,fs))
;
;
; =============================================================================
;
; choose.feedset
; --------------
;
;       arguments     : fs - <feeder set>
;
;       returns       : <feeder>
;
;       description   : returns the first <feeder> in "fs"
;
;                                        written :  rgh 08/21/85
;                                        modified:
;
;
(defmacro choose.feedset (fs)
  `(choose.Set ,fs))
;
;
; =============================================================================
;
; others.feedset
; --------------
;
;       arguments     : fs - <feeder set>
;
;       returns       : <feeder set>
;
;       description   : returns a <feeder set> consisting of all of the
;                       <feeder>s in "fs" except the first
;
;                                        written :  rgh 08/21/85
;                                        modified:
;
;
(defmacro others.feedset (fs)
  `(others.Set ,fs))
;
;
; =============================================================================
;
; insert.feedset
; --------------
;
;       arguments     : feeder - <feeder>
;                       feederset - <feeder set>
;
;       returns       : <feeder set>
;
;       description   : returns a <feeder set> identical to "feederset", but
;                       with "feeder" inserted if there was not already an
;                       equivalent one there
;
;                                        written :  rgh 11/30/85
;                                        modified:  cpf 10/07/88
;
;
(defmacro insert.feedset (feeder feederset)
  `(prog (f fs)
	 (setq fs ,feederset)
      begin
         (if (isnew.feedset fs) (return (putin.Set ,feeder ,feederset)))
	 (setq f (choose.feedset fs))
         (cond ((equivalent.feeder f ,feeder)
		(rplaca (cdddr f) (valve.feeder ,feeder))
		(return ,feederset)))
	 (setq fs (others.feedset fs))
	 (go begin)))
;
;
; =============================================================================



    
    




