;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: restriction.lisp,v 1.7 2004/08/26 23:26:08 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; <restriction>  ::=  ( <substitution> . <mnoderep set> )
;
; -----------------------------------------------------------------------------
;
; PRIMITIVE      new.restr    :  --> <restriction>
;  ELEMENTS
;
; RECOGNIZERS    is.restr     :  <universal> --> <boolean>
;                isnew.restr  :  <restriction> --> <boolean>
;
; CONSTRUCTORS   make.restr   :  <substitution> x <mnoderep set>
;                                        --> <restriction>
;
; SELECTORS      subst.restr  :  <restriction> --> <substitution>
;                mnrs.restr   :  <restriction> --> <mnoderep set>
;
; TESTS          equivalent.restr : <restriction> x <restriction> --> <boolean>
;
; =============================================================================
;
; new.restr
; ---------
;
;       returns       : <restriction>
;
;       description   : creates a <new restriction>
;
;                                        written :  rgh 08/17/85
;                                        modified:
;
;
(defmacro new.restr ()
  `(new.sbst))
;
;
; =============================================================================
;
; is.restr
; ---------
;
;       arguments     : u - <universal>
;
;       returns       : <boolean>
;
;       description   : returns "true" is "u" is a <restriction>,
;                               "false" otherwise
;
;                                        written :  rgh 08/17/85
;                                        modified:  rgh 08/21/85
;
;
(defmacro is.restr (u)
  `(and (consp ,u)
        (is.sbst (car ,u))
        (is.mnrs (cdr ,u))))
;
;
; =============================================================================
;
; subst.restr
; ------------
;
;       arguments     : r - <restriction>
;
;       returns       : <substitution>
;
;       description   : returns the <substitution> of the <restriction> "r"
;
;                                        written :  rgh 08/17/85
;                                        modified:
;
;
(defmacro subst.restr (r)
  `(car ,r))
;
;
; =============================================================================
;
; isnew.restr
; ------------
;
;       arguments     : r - <restriction>
;
;       returns       : <boolean>
;
;       description   : returns "true" is "r" is a <new restriction>,
;                               "false" otherwise
;
;       implementation: simply tests to see if the <substitution> of the
;                        <restriction> is "new", since the <mnoderep set>
;                        would never be looked at anyway if this is true.
;
;                                        written :  rgh 08/17/85
;                                        modified:
;
;
(defmacro isnew.restr (r)
  `(isnew.sbst (subst.restr ,r)))
;
;
; =============================================================================
;
; make.restr
; -----------
;
;       arguments     : subst - <substitution>
;                       mnrs - <mnoderep set>
;
;       returns       : <restriction>
;
;       description   : returns a <restriction> composed of the arguments
;
;                                        written :  rgh 08/17/85
;                                        modified:  ssc 10/24/88
;
;
(defmacro make.restr (subst)
  `(list ,subst))
;
;
; =============================================================================
;
; mnrs.restr
; -----------
;
;       arguments     : r - <restriction>
;
;       returns       : <mnoderep set>
;
;       description   : returns the <mnoderep set> of the <restriction> "r"
;
;                                        written :  rgh 08/17/85
;                                        modified:
;
;
(defmacro mnrs.restr (r)
  `(cdr ,r))
;
;
; =============================================================================
;
; equivalent.restr
; ----------------
;
;       arguments     : r1 - <restriction>
;                       r2 - <restriction>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "r1" and "r2" are equivalent
;                       <restriction>s in the sense that each <instance>
;                       which satisfies one will satisfy the other.
;
;       implementation: two <restriction>s are equivalent if their
;                       <substitution>s match exactly, with the possible
;                       exception that two i-nodes (or u-nodes) with the
;                       exact same structure may have different names
;                       (<msyms>).
;
;                                        written :  rgh 08/18/85
;                                        modified:  ssc 11/28/88
;
;
(defun equivalent.restr (r1 r2)
  (let (term
	(s1 (subst.restr r1))
	(s2 (subst.restr r2)))
    (when (eql (cardinality.sbst s1) (cardinality.sbst s2))
      (do.sbst (next-mb s1 t)
	 (unless (and (setq term (term.sbst (mvar.mb next-mb) s2))
		      (sneps::iseq.n (mnode.mb next-mb) term))
		 (return nil))))))
;
;
; =============================================================================




    
    




