;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: ruiset.lisp,v 1.6 2004/08/26 23:26:08 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; <rule-use-info set> ::=  { <rule-use-info> ... }
;
; -----------------------------------------------------------------------------
;
; PRIMITIVE      new.ruis :  --> <rule-use-info set>
;  ELEMENTS
;
; RECOGNIZERS    isnew.ruis : <rule-use-info set> --> <boolean>
;
; CONSTRUCTORS   makeone.ruis : <rule-use-info> --> <rule-use-info set>
;                putin.ruis   : <rule-use-info> x <rule-use-info set>
;                                  --> <rule-use-info set>
;                update.ruis  : <rule-use-info> x <rule-use-info set>
;                                  --> <rule-use-info set>
;
; SELECTORS      choose.ruis : <rule-use-info set> --> <rule-use-info>
;                others.ruis : <rule-use-info set> --> <rule-use-info set>
;
; =============================================================================
;
; new.ruis
; --------
;
;       returns       : <rule-use-info set>
;
;       description   : returns a "new" <rule-use-info set>
;
;                                        written :  rgh  2/13/86
;                                        modified:
;
;
(defmacro new.ruis ()
  `(new.Set))
;
;
; =============================================================================
;
; isnew.ruis
; ----------
;
;       arguments     : ruis - <rule-use-info set>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "ruis" is a "new" <rule-use-info
;                       set>
;
;                                        written :  rgh  2/13/86
;                                        modified:
;
;
(defmacro isnew.ruis (ruis)
  `(isnew.Set ,ruis))
;
;
; =============================================================================
;
; makeone.ruis
; ------------
;
;       arguments     : rui - <rule-use-info>
;
;       returns       : <rule-use-info set>
;
;       description   : returns a singleton <rule-use-info set> containing
;                       "rui"
;
;                                        written :  rgh  4/03/86
;                                        modified:
;
;
(defmacro makeone.ruis (rui)
  `(makeone.Set ,rui))
;
;
; =============================================================================
;
; putin.ruis
; ----------
;
;       arguments     : rui - <rule-use-info>
;                       ruis - <rule-use-info set>
;
;       returns       : <rule-use-info set>
;
;       description   : returns a <rule-use-info set> consisting of "rui"
;                       added to the elements of "ruis".  Assumes that "rui"
;                       is not already in "ruis".
;
;                                        written :  rgh  4/03/86
;                                        modified:
;
;
(defmacro putin.ruis (rui ruis)
  `(putin.Set ,rui ,ruis))
;
;
; =============================================================================
;
; choose.ruis
; -----------
;
;       arguments     : ruis - <rule-use-info set>
;
;       returns       : <rule-use-info>
;
;       description   : returns an element of "ruis"
;
;                                        written :  rgh  2/13/86
;                                        modified:
;
;
(defmacro choose.ruis (ruis)
  `(choose.Set ,ruis))
;
;
; =============================================================================
;
; others.ruis
; -----------
;
;       arguments     : ruis - <rule-use-info set>
;
;       returns       : <rule-use-info set>
;
;       description   : returns a <rule-use-info set> exactly like "ruis"
;                       except with the element chosen by choose.ruis
;                       removed
;
;                                        written :  rgh  2/13/86
;                                        modified:
;
;
(defmacro others.ruis (ruis)
  `(others.Set ,ruis))
;
;
; =============================================================================
;
; update.ruis
; -----------
;
;       arguments     : updated-rui - <rule-use-info>
;                       ruiset - <rule-use-info set>
;
;       returns       : <rule-use-info set>
;
;       description   : updates "ruiset" by adding "updated-rui" in place of
;                       an already existing <rule-use-info> with the same
;                       <substitution> and not icompatible with it.
;                       "Updated-rui" is merged with the
;                       the already existing <rule-use-info> if one is found,
;                       in that the poscount, negcount and flagged node set
;                       are updated to contain all information contained
;                       in both <rule-use-info>s.
; 
;
;                                        written :  rgh  4/03/86
;                                        modified:  rgh  4/26/86
;                                        modified:  njm 11/09/88
;
;
(defun update.ruis (updated-rui ruiset)
  (cond ((isnew.ruis ruiset) (makeone.ruis updated-rui))
        ((and (iseq.sbst (subst.rui updated-rui)
			 (subst.rui (choose.ruis ruiset)))
	      (compatible.rui updated-rui (choose.ruis ruiset)))
	 (putin.ruis
	   (merge.rui updated-rui (choose.ruis ruiset))
	   (others.ruis ruiset)))
        (t (putin.ruis (choose.ruis ruiset)
		       (update.ruis updated-rui (others.ruis ruiset))))))
;
;
; =============================================================================



    
    




