;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: switch.lisp,v 1.6 2004/08/26 23:26:08 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; <switch>  ::=  <substitution>
;
; -----------------------------------------------------------------------------
;
; PRIMITIVE      new.switch :  --> <switch>
;  ELEMENTS
;
; RECOGNIZERS    is.switch  :  <universal> --> <boolean>
;
; =============================================================================
;
; new.switch
; ----------
;
;       returns       : <switch>
;
;       description   : returns a "new" <switch>
;
;                                        written :  rgh 11/18/85
;                                        modified:
;
;
(defmacro new.switch ()
  `(new.sbst))
;
;
; =============================================================================
;
; is.switch
; ---------
;
;       arguments     : u - <universal>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "u" is a <switch>, "false" otherwise
;
;                                        written :  rgh 11/18/85
;                                        modified:
;
;
(defmacro is.switch (u)
  `(is.sbst ,u))
;
;
; =============================================================================



    
    




