;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1993--2004
;; Research Foundation of State University of New York

;; Version: $Id: achieve.lisp,v 1.8 2004/08/26 23:26:11 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;;;
;;; Representation
;;;
;;;   act = action act-node
;;;         objecti ith-argument to act-node


(defun achieve (n)
  "Tries to find plans to make the object1 proposition true.
   If it does, chooses one, and schedules it."
  (let ((prop (choose.ns (sneps::pathfrom '(snepsul::object1) n)))
	(n-act (activation.n n))
	plans)
    (case (regfetch n-act '*AGENDA*)
      (START
	    (plantrace "Want to achieve " (list prop) nil)	
       (cond ((isassert.n prop)
	      (format t "~&~%Already Achieved.~%")
	      (regstore n-act '*AGENDA* 'DONE))
	     (t 
		(regstore n-act '*AGENDA* 'FIND-PLANS)
		(initiate n-act)
		(plantrace "Want to find a plan to achieve" (list prop) nil)
		(find-gplans n prop))))
      (FIND-PLANS
       (setf plans (regfetch n-act '*REPORTS*))
       (plantrace
	(format nil         ;;; altered by flj 2/12/04 (for scs)
		"The goal can~[not~:;~] be achieved.~:*~
                  ~[~:; by the following plan~:p:~] "	
		(length plans))
		  plans nil)
       (cond (plans
	      (regstore n-act '*AGENDA* 'DONE)
	      (schedule-plans plans))
	     (t (format t "DEAD END!!")))))))
;
;
(defun find-gplans (achieve-act prop)
  "Initiates a deduction process to find plans that decompose the
   currently active complex act process."
  (declare (special *USER-PROCESS* *ADDED-NODES* *DEDUCTION-RESULTS*
			    CRNTCT))
  (let (pr deduction-target) 
    (unless (and (snepsul::* 'gplan)
                 (sneps::isvar.n (first (snepsul::* 'gplan))))
	    (snepsul::$ 'gplan))
    (setq deduction-target
          (choose.ns (eval `(sneps:build snepsul::plan (snepsul::* 'gplan)
			     snepsul::goal  ,prop))))
    (setq *ADDED-NODES* (new.ns))
    (setq *DEDUCTION-RESULTS* (new.ns))
    (setq *USER-PROCESS*
	  (new 'user
	       (new.repset)
	       crntct
	       (new.ns)
	       nil
	       nil
	       nil
	       0
	       0
	       (activation.n achieve-act)
	       'HIGH))
    (activate.n deduction-target)
    (setq pr (activation.n deduction-target))
    (regstore pr '*REQUESTS*
	         (insert.chset (make.ch (new.filter)
					(new.switch)
					(sneps:value.sv crntct)
					;*NODE*
					'user
					'open)
			        (regfetch pr '*REQUESTS*)))
    (regstore pr '*PRIORITY* 'LOW)
    (initiate pr)
  ))



    
    




