;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: deduce.lisp,v 1.9 2004/08/26 23:26:12 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


(defun deduce* (how-many targetset)
  (declare (special *USER-PROCESS* *ADDED-NODES* *DEDUCTION-RESULTS* CRNTCT))
  (let ((inference-context (sneps:value.sv crntct))
	deduction-target pr)
    (when-intensional-contexts
     ;; Use the context name
     (setq inference-context crntct))
    (setq *ADDED-NODES* (new.ns))		;special var
    (setq *DEDUCTION-RESULTS* (new.ns))		;special var
;   (clear-lastinfer)
    (if (isnew.ns targetset) *DEDUCTION-RESULTS*)
    (setq deduction-target (choose.ns targetset))
    (setq *USER-PROCESS*
	  (new 'user
	       (new.repset)
	       crntct
	       (new.ns)
	       (if (numberp how-many) how-many)
	       (if (not (atom how-many)) (car how-many))
	       (if (not (atom how-many)) (cadr how-many))
	       0
	       0
	       'USER
	       'HIGH))
    (activate.n deduction-target)
    (setq pr (activation.n deduction-target))
    (regstore pr '*REQUESTS*
	      (insert.chset
		(make.ch (new.filter)
			 (new.switch)
			 inference-context
			 'USER
			 'OPEN)
		(regfetch pr '*REQUESTS*)))
    (regstore pr '*PRIORITY* 'LOW)
    (multip (dequeue:new)                               ; act-queue
	    (dequeue:insert-rear pr (dequeue:new))      ; high priority
	    (dequeue:new))                              ; low priority
    *DEDUCTION-RESULTS*))



;(defun clear-lastinfer ()
;  (progn
;    (setf (get 'lastinfer nil) '%events-queue%)
;    (setf (get 'lastinfer nil) '%user-process%)))

;(defun clear-lastinfer ()
;;  ;; this is how it should be if it was used (hc)
;;  (setf (get 'lastinfer '%events-queue%) nil)
;;  (setf (get 'lastinfer '%user-process%) nil)
;   nil)

(defmacro isnumbfield (x)
  `(or (and (atom ,x) (numberp ,x))
       (and (listp ,x)
            (atom (car ,x)) (numberp (car ,x))
            (atom (cadr ,x)) (numberp (cadr ,x)))))


(defsnepscom deduce ((&rest snd) (top ns bns tbns fns))
  (let* ((numberfield (if (isnumbfield (car snd)) (car snd)))
	 (sd  (if numberfield (sneps:getsndescr (cdr snd))
		(sneps:getsndescr snd)))
	 (crntct (if numberfield (sneps:processcontextdescr (cdr snd))
		   (sneps:processcontextdescr snd)))
	 (crntctname crntct)) 
    (declare (special crntct crntctname))
    (values (deduce* numberfield
		     (sneps::nseval (cons 'sneps:build sd)))
	    crntctname)))



    
    




