;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: deducetrue.lisp,v 1.4 2004/08/26 23:26:12 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


(defun deducetrue* (how-many targetset)
  (declare (special *USER-PROCESS* *ADDED-NODES* *DEDUCTION-RESULTS* CRNTCT))
  (let ((inference-context (sneps:value.sv crntct))
	deduction-target pr)
    (when-intensional-contexts
     ;; Use the context name
     (setq inference-context crntct))
    (setq *ADDED-NODES* (new.ns))		;special var
    (setq *DEDUCTION-RESULTS* (new.ns))		;special var
;   (clear-lastinfer)
    (if (isnew.ns targetset) *DEDUCTION-RESULTS*)
    (setq deduction-target (choose.ns targetset))
    (setq *USER-PROCESS*
	  (new 'posuser
	       (new.repset)
	       crntct
	       (new.ns)
	       (if (numberp how-many) how-many)
	       (if (not (atom how-many)) (car how-many))
	       (if (not (atom how-many)) (cadr how-many))
	       0
	       0
	       'USER
	       'HIGH))
    (activate.n deduction-target)
    (setq pr (activation.n deduction-target))
    (regstore pr '*REQUESTS*
	      (insert.chset
		(make.ch (new.filter)
			 (new.switch)
			 inference-context
			 'USER
			 'OPEN)
		(regfetch pr '*REQUESTS*)))
    (regstore pr '*PRIORITY* 'LOW)
    (multip (dequeue:new)                               ; act-queue
	    (dequeue:insert-rear pr (dequeue:new))      ; high priority
	    (dequeue:new))                              ; low priority
    *DEDUCTION-RESULTS*))

(defsnepscom deducetrue ((&rest snd) (top ns bns tbns fns))
  (let* ((numberfield (if (isnumbfield (car snd)) (car snd)))
	 (sd  (if numberfield (sneps:getsndescr (cdr snd))
		(sneps:getsndescr snd)))
	 (crntct (if numberfield (sneps:processcontextdescr (cdr snd))
		   (sneps:processcontextdescr snd)))
	 (crntctname crntct)) 
    (declare (special crntct crntctname))
    (values (deducetrue* numberfield
		     (sneps::nseval (cons 'sneps:build sd)))
	    crntctname)))

(defsnepscom deducewh ((&rest snd) (top ns bns tbns fns))
  (let* ((numberfield (if (isnumbfield (car snd)) (car snd)))
	 (sd  (if numberfield (sneps:getsndescr (cdr snd))
		(sneps:getsndescr snd)))
	 (crntct (if numberfield (sneps:processcontextdescr (cdr snd))
		   (sneps:processcontextdescr snd)))
	 (crntctname crntct)) 
    (declare (special crntct crntctname))
    (values (deducewh* numberfield
		     (sneps::nseval (cons 'sneps:build sd)))
	    crntctname)))

(defun deducewh* (how-many targetset)
  (declare (special *USER-PROCESS* *ADDED-NODES* *DEDUCTION-RESULTS* CRNTCT))
  (let ((inference-context (sneps:value.sv crntct))
	deduction-target pr)
    (when-intensional-contexts
     ;; Use the context name
     (setq inference-context crntct))
    (setq *ADDED-NODES* (new.ns)) ;special var
    (setq *DEDUCTION-RESULTS* (new.ns)) ;special var
				;   (clear-lastinfer)
    (if (isnew.ns targetset) *DEDUCTION-RESULTS*)
    (setq deduction-target (choose.ns targetset))
    (setq *USER-PROCESS*
      (new 'whuser
	   (sneps:node-freevars deduction-target)
	   (new.repset)
	   crntct
	   (new.ns)
	   (if (numberp how-many) how-many)
	   (if (not (atom how-many)) (car how-many))
	   (if (not (atom how-many)) (cadr how-many))
	   0
	   0
	   'USER
	   'HIGH))
    (activate.n deduction-target)
    (setq pr (activation.n deduction-target))
    (regstore pr '*REQUESTS*
	      (insert.chset
	       (make.ch (new.filter)
			(new.switch)
			inference-context
			'USER
			'OPEN)
	       (regfetch pr '*REQUESTS*)))
    (regstore pr '*PRIORITY* 'LOW)
    (multip (dequeue:new)	; act-queue
	    (dequeue:insert-rear pr (dequeue:new)) ; high priority
	    (dequeue:new))	; low priority
    *DEDUCTION-RESULTS*))



(defun whuser (*NAME* *VARS* *REPORTS* *CONTEXT-NAME* *DEDUCED-NODES*
		*TOTAL-DESIRED* *POS-DESIRED* *NEG-DESIRED*
		*POS-FOUND* *NEG-FOUND* *CLIENT* *PRIORITY*)
  "Like the user process function, but only collects positive answers."
  (declare (special multi::curnt%))
  (let ((reports *REPORTS*))
    (setq *REPORTS* (new.repset))
    (do.repset (report reports)
       (let ((n (node.rep report)))
	 (unless (or (ismemb.ns n *DEDUCED-NODES*)
		     (not (eq (sign.rep report) 'POS)))
		 (tally report)
		 (setq *DEDUCED-NODES*
		   (union.ns
		    (mapcar #'(lambda (v)
				(match::applysubst v (subst.rep report)))
			    *VARS*)
		    *DEDUCED-NODES*))))))
  (setq *DEDUCTION-RESULTS* (union.ns *DEDUCED-NODES* *DEDUCTION-RESULTS*))
    (if (not (eq *CLIENT* 'snip::user))            ;; *CLIENT* can be a node
      (send-to-client *CLIENT* *DEDUCED-NODES*))
    (if (enough-answers) (suspend-inference))
    (set multi::curnt% (list *NAME* *VARS* *REPORTS* *CONTEXT-NAME*
			     *DEDUCED-NODES* *TOTAL-DESIRED*
			     *POS-DESIRED* *NEG-DESIRED* *POS-FOUND*
			     *NEG-FOUND* *CLIENT* *PRIORITY*)))

(setf (get 'whuser 'multi::lregs%)
  '(*NAME* *VARS* *REPORTS* *CONTEXT-NAME* *DEDUCED-NODES* *TOTAL-DESIRED*
    *POS-DESIRED* *NEG-DESIRED* *POS-FOUND* *NEG-FOUND*
    *CLIENT* *PRIORITY*))

(defun deducefalse* (how-many targetset)
  (declare (special *USER-PROCESS* *ADDED-NODES* *DEDUCTION-RESULTS* CRNTCT))
  (let ((inference-context (sneps:value.sv crntct))
	deduction-target pr)
    (when-intensional-contexts
     ;; Use the context name
     (setq inference-context crntct))
    (setq *ADDED-NODES* (new.ns))		;special var
    (setq *DEDUCTION-RESULTS* (new.ns))		;special var
;   (clear-lastinfer)
    (if (isnew.ns targetset) *DEDUCTION-RESULTS*)
    (setq deduction-target (choose.ns targetset))
    (setq *USER-PROCESS*
	  (new 'neguser
	       (new.repset)
	       crntct
	       (new.ns)
	       (if (numberp how-many) how-many)
	       (if (not (atom how-many)) (car how-many))
	       (if (not (atom how-many)) (cadr how-many))
	       0
	       0
	       'USER
	       'HIGH))
    (activate.n deduction-target)
    (setq pr (activation.n deduction-target))
    (regstore pr '*REQUESTS*
	      (insert.chset
		(make.ch (new.filter)
			 (new.switch)
			 inference-context
			 'USER
			 'OPEN)
		(regfetch pr '*REQUESTS*)))
    (regstore pr '*PRIORITY* 'LOW)
    (multip (dequeue:new)                               ; act-queue
	    (dequeue:insert-rear pr (dequeue:new))      ; high priority
	    (dequeue:new))                              ; low priority
    *DEDUCTION-RESULTS*))

(defsnepscom deducefalse ((&rest snd) (top ns bns tbns fns))
  (let* ((numberfield (if (isnumbfield (car snd)) (car snd)))
	 (sd  (if numberfield (sneps:getsndescr (cdr snd))
		(sneps:getsndescr snd)))
	 (crntct (if numberfield (sneps:processcontextdescr (cdr snd))
		   (sneps:processcontextdescr snd)))
	 (crntctname crntct)) 
    (declare (special crntct crntctname))
    (values (deducefalse* numberfield
		     (sneps::nseval (cons 'sneps:build sd)))
	    crntctname)))

(defun neguser (*NAME* *REPORTS* *CONTEXT-NAME* *DEDUCED-NODES* *TOTAL-DESIRED*
	     *POS-DESIRED* *NEG-DESIRED* *POS-FOUND* *NEG-FOUND*
		*CLIENT* *PRIORITY*)
  "Like the user process function, but only collects positive answers."
  (declare (special multi::curnt%))
  (let ((reports *REPORTS*))
    (setq *REPORTS* (new.repset))
    (do.repset (report reports)
       (let ((n (node.rep report)))
	 (unless (or (ismemb.ns n *DEDUCED-NODES*)
		     (not (eq (sign.rep report) 'NEG)))
		 (tally report)
		 (setq *DEDUCED-NODES* (insert.ns n *DEDUCED-NODES*))))))
  (setq *DEDUCTION-RESULTS* (union.ns *DEDUCED-NODES* *DEDUCTION-RESULTS*))
    (if (not (eq *CLIENT* 'snip::user))            ;; *CLIENT* can be a node
      (send-to-client *CLIENT* *DEDUCED-NODES*))
  (if (enough-answers) (suspend-inference))
  (set multi::curnt% (list *NAME* *REPORTS* *CONTEXT-NAME* *DEDUCED-NODES*
			   *TOTAL-DESIRED* *POS-DESIRED* *NEG-DESIRED*
			   *POS-FOUND* *NEG-FOUND* *CLIENT* *PRIORITY*)))

(setf (get 'neguser 'multi::lregs%)
  '(*NAME* *REPORTS* *CONTEXT-NAME* *DEDUCED-NODES* *TOTAL-DESIRED*
    *POS-DESIRED* *NEG-DESIRED* *POS-FOUND* *NEG-FOUND*
    *CLIENT* *PRIORITY*))


(defsnepscom deducewhnot ((&rest snd) (top ns bns tbns fns))
  (let* ((numberfield (if (isnumbfield (car snd)) (car snd)))
	 (sd  (if numberfield (sneps:getsndescr (cdr snd))
		(sneps:getsndescr snd)))
	 (crntct (if numberfield (sneps:processcontextdescr (cdr snd))
		   (sneps:processcontextdescr snd)))
	 (crntctname crntct)) 
    (declare (special crntct crntctname))
    (values (deducewhnot* numberfield
		     (sneps::nseval (cons 'sneps:build sd)))
	    crntctname)))

(defun deducewhnot* (how-many targetset)
  (declare (special *USER-PROCESS* *ADDED-NODES* *DEDUCTION-RESULTS* CRNTCT))
  (let ((inference-context (sneps:value.sv crntct))
	deduction-target pr)
    (when-intensional-contexts
     ;; Use the context name
     (setq inference-context crntct))
    (setq *ADDED-NODES* (new.ns)) ;special var
    (setq *DEDUCTION-RESULTS* (new.ns)) ;special var
				;   (clear-lastinfer)
    (if (isnew.ns targetset) *DEDUCTION-RESULTS*)
    (setq deduction-target (choose.ns targetset))
    (setq *USER-PROCESS*
      (new 'notwhuser
	   (sneps:node-freevars deduction-target)
	   (new.repset)
	   crntct
	   (new.ns)
	   (if (numberp how-many) how-many)
	   (if (not (atom how-many)) (car how-many))
	   (if (not (atom how-many)) (cadr how-many))
	   0
	   0
	   'USER
	   'HIGH))
    (activate.n deduction-target)
    (setq pr (activation.n deduction-target))
    (regstore pr '*REQUESTS*
	      (insert.chset
	       (make.ch (new.filter)
			(new.switch)
			inference-context
			'USER
			'OPEN)
	       (regfetch pr '*REQUESTS*)))
    (regstore pr '*PRIORITY* 'LOW)
    (multip (dequeue:new)	; act-queue
	    (dequeue:insert-rear pr (dequeue:new)) ; high priority
	    (dequeue:new))	; low priority
    *DEDUCTION-RESULTS*))

(defun notwhuser (*NAME* *VARS* *REPORTS* *CONTEXT-NAME* *DEDUCED-NODES*
		*TOTAL-DESIRED* *POS-DESIRED* *NEG-DESIRED*
		*POS-FOUND* *NEG-FOUND* *CLIENT* *PRIORITY*)
  "Like the user process function, but only collects positive answers."
  (declare (special multi::curnt%))
  (let ((reports *REPORTS*))
    (setq *REPORTS* (new.repset))
    (do.repset (report reports)
       (let ((n (node.rep report)))
	 (unless (or (ismemb.ns n *DEDUCED-NODES*)
		     (not (eq (sign.rep report) 'NEG)))
		 (tally report)
		 (setq *DEDUCED-NODES*
		   (union.ns
		    (mapcar #'(lambda (v)
				(match::applysubst v (subst.rep report)))
			    *VARS*)
		    *DEDUCED-NODES*))))))
  (setq *DEDUCTION-RESULTS* (union.ns *DEDUCED-NODES* *DEDUCTION-RESULTS*))
    (if (not (eq *CLIENT* 'snip::user))            ;; *CLIENT* can be a node
      (send-to-client *CLIENT* *DEDUCED-NODES*))
    (if (enough-answers) (suspend-inference))
    (set multi::curnt% (list *NAME* *VARS* *REPORTS* *CONTEXT-NAME*
			     *DEDUCED-NODES* *TOTAL-DESIRED*
			     *POS-DESIRED* *NEG-DESIRED* *POS-FOUND*
			     *NEG-FOUND* *CLIENT* *PRIORITY*)))

(setf (get 'notwhuser 'multi::lregs%)
  '(*NAME* *VARS* *REPORTS* *CONTEXT-NAME* *DEDUCED-NODES* *TOTAL-DESIRED*
    *POS-DESIRED* *NEG-DESIRED* *POS-FOUND* *NEG-FOUND*
    *CLIENT* *PRIORITY*))



    
    




