;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1993--2004
;; Research Foundation of State University of New York

;; Version: $Id: do-all.lisp,v 1.7 2004/08/26 23:26:12 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;;;
;;; Representation
;;;
;;;   act = action act-node
;;;         objecti ith-argument to act-node


(defun do-all (n)
  "Schedules the performing of all the actions on the queue."
  (let ((all-acts (sneps::pathfrom '(snepsul::object1) n))
	(pr (activation.n n)))
    (plantrace "Now doing: DO-ALL " all-acts nil)
    (do.ns (act all-acts)
	   (schedule-act act))
    (regstore pr '*AGENDA* 'DONE)))



    
    




