;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1993--2004
;; Research Foundation of State University of New York

;; Version: $Id: do-if.lisp,v 1.5 2004/08/26 23:26:12 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;  DO-IF functions
;
(defun rule-handler.do-if (ant-act cqch)
  (let ((sensory-act (choose.ns (makeone.ns
				 (match::applysubst (choose.ns ant-act)
						    (filter.ch cqch)))))
	pr)
    (remark `"~%Since" (makeone.ns *NODE*) nil)
    (remark `"~%I will perform" (makeone.ns sensory-act) nil)
    (activate.n sensory-act)
    (setq pr (activation.n sensory-act))
    (regstore pr '*PRIORITY* 'INTEND)
    (regstore pr '*AGENDA* 'START)
    (multi:schedule pr multi::*act-queue*)
    t))

;
; =============================================================================
;

(defun usability-test.do-if (sign)
  (declare (special *NODE*))
  (and (eq sign 'POS)
       (or (isnew.ns (quantified-vars.n *NODE*))
           (not (isnew.ns (nodeset.n *NODE* 'sneps::forall))))))


;
;
; =============================================================================





    
    




