;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1993--2004
;; Research Foundation of State University of New York

;; Version: $Id: dynamic-add.lisp,v 1.6 2004/08/26 23:26:12 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; dynamic-add
; -----------
;
;       arguments     : snd - <snepsul node description>
;
;       returns       : <node set>
;
;       description   : top-level SNePSUL function which adds a node to the
;                       network and then tries to do forward inference
;                       using it.
;
;       side-effects  : may build new nodes in the network.
;                       Initiates the variable 'crntctname' with the name given
;                       by the user to the context where the inference must be 
;                       done.
;
;                                        written :  dk: 6/93
;
(defsnepscom dynamic-add ((&rest snd) add)
   (let* ((crntct (sneps:processcontextdescr snd))
	  (crntctname crntct))
     (declare (special crntct crntctname))
     (values (dynamic-add* (sneps::nseval (cons 'sneps:assert snd)))
	     crntctname)))

;
;
; =============================================================================
;
; dynamic-add*
; ----
;
;       arguments     : new-nodes - <nodefun set>
;
;       returns       : <nodefun set>
;
;       description   : see dynamic-add
;
;       side-effects  : see dynamic-add
;
;                                        written :  rgh  4/20/86
;                                        modified:  scs  4/20/88
;                                        modified:  njm/cpf 10/19/88
;                                                   hc/njm  04/26/89
;                                                   dk 6/2/93
; added act-queue to the call to MULTIP -: dk
;
(defun dynamic-add* (new-nodes)
  (declare (special *ADDED-NODES* crntct))
  (let ((inference-context (sneps:value.sv crntct))
	new-nodefun pr)
    (when-intensional-contexts
     ;; Use the context name
     (setq inference-context crntct))
    (setq *ADDED-NODES* new-nodes)	;special var
    (if (isnew.ns new-nodes) *ADDED-NODES*)
    (setq new-nodefun (choose.ns new-nodes))
    (when (ismol.n new-nodefun)
      (activate.n new-nodefun)
      (setq pr (activation.n new-nodefun))
      (regstore pr '*REPORTS*
		(insert.repset
		 (make.rep (new.sbst)
			   (filter.sup (sneps:node-asupport new-nodefun)
				       (sneps:value.sv crntct))
			   'POS
			   'SENSOR
			   new-nodefun
			   inference-context)
		 (regfetch pr '*REPORTS*)))
      (regstore pr '*PRIORITY* 'HIGH)
      (initiate pr))
    *ADDED-NODES*))
;
;
; =============================================================================









    
    




