;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: icontext.lisp,v 1.5 2004/08/26 23:26:12 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


(defvar *use-intensional-contexts* t
  "If t use context names instead of actual context structures as the
contexts passed back and forth in SNIP data structures.")

(defmacro when-intensional-contexts (&rest body)
  `(when *use-intensional-contexts*
    ,@body))

;; For proper linking of sub contexts to super contexts we'll need some
;; access functions which should go here. E.g., if during hypothetical
;; reasoning we get stuck somewhere and later add a node to the default
;; context to continue the deduction, the newly added node has to be
;; inherited by the hypothetical reasoning context in order to be useful
;; there.



    
    




