;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: make.lisp,v 1.7 2004/08/26 23:26:12 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


(defun make-v-ent (n)
   (multi:new 'rule              ; NAME:
        'or-entailment           ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:              
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.v-ent      ; RULE-HANDLER:
        'usability-test.v-ent))  ; USABILITY-TEST:

(defun make-&-ent (n)
   (multi:new 'rule              ; NAME:
        'and-entailment          ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.&-ent      ; RULE-HANDLER:
        'usability-test.&-ent))  ; USABILITY-TEST:

(defun make-thresh (n)
   (multi:new 'rule              ; NAME:
        'thresh                  ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.thresh     ; RULE-HANDLER:
        'usability-test.thresh)) ; USABILITY-TEST:

(defun make-nor (n)
   (multi:new 'rule              ; NAME:
	'nor                     ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.nor        ; RULE-HANDLER:
        'usability-test.nor))    ; USABILITY-TEST:

(defun make-and (n)
   (multi:new 'rule              ; NAME:
        'and                     ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.and        ; RULE-HANDLER:
        'usability-test.and))    ; USABILITY-TEST:

(defun make-and-or (n)
   (multi:new 'rule              ; NAME:
        'and-or                  ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.and-or     ; RULE-HANDLER:
        'usability-test.and-or)) ; USABILITY-TEST:

(defun make-num-ent (n)
   (multi:new 'rule                ; NAME:
        'num-entailment            ; TYPE:
        n                          ; NODE:
        (new.iset)                 ; KNOWN-INSTANCES:
        (new.repset)               ; REPORTS:
        (new.chset)                ; REQUESTS:
        (new.feedset)              ; INCOMING-CHANNELS:
        (new.chset)                ; OUTGOING-CHANNELS:
        (new.cqchset)              ; RULE-USE-CHANNELS:
	(new.ichset)               ; INTRODUCTION-CHANNELS:
        (new.repset)               ; PENDING-FORWARD-INFERENCES:
        nil                        ; PRIORITY:
        'rule-handler.num-ent      ; RULE-HANDLER:
        'usability-test.num-ent))  ; USABILITY-TEST:

(defun make-num-quant (n)
  (multi:new 'num-quant.rule
        'num-quantifier              ; TYPE:
        n                            ; NODE:
        (new.iset)                   ; KNOWN-INSTANCES:
	nil                          ; NUM-QUANT-POS-INSTANCES:
	nil                          ; NUM-QUANT-NEG-INSTANCES:
        (new.repset)                 ; REPORTS:
        (new.chset)                  ; REQUESTS:
        (new.feedset)                ; INCOMING-CHANNELS:
        (new.chset)                  ; OUTGOING-CHANNELS:
        (new.cqchset)                ; RULE-USE-CHANNELS:
	(new.ichset)                 ; INTRODUCTION-CHANNELS:
        (new.repset)                 ; PENDING-FORWARD-INFERENCES:
        nil                          ; PRIORITY:
        'rule-handler.num-quant      ; RULE-HANDLER:
        'usability-test.num-quant))  ; USABILITY-TEST:

(defun make-non-deriv (n)
   (multi:new 'rule                  ; NAME:
        'non-derivable               ; TYPE:
        n                            ; NODE:
        (new.iset)                   ; KNOWN-INSTANCES:
        (new.repset)                 ; REPORTS:
        (new.chset)                  ; REQUESTS:
        (new.feedset)                ; INCOMING-CHANNELS:
        (new.chset)                  ; OUTGOING-CHANNELS:
        (new.cqchset)                ; RULE-USE-CHANNELS:
	(new.ichset)                 ; INTRODUCTION-CHANNELS:
        (new.repset)                 ; PENDING-FORWARD-INFERENCES:
        nil                          ; PRIORITY:
        'rule-handler.non-deriv      ; RULE-HANDLER:
        'usability-test.non-deriv))  ; USABILITY-TEST:

(defun make-do-if (n)
   (multi:new 'rule              ; NAME:
	'do-if                   ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:              
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.do-if      ; RULE-HANDLER:
        'usability-test.do-if))  ; USABILITY-TEST:

(defun make-when-do (n)
   (multi:new 'rule              ; NAME:
	'when-do                 ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:              
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.when-do    ; RULE-HANDLER:
        'usability-test.when-do)); USABILITY-TEST:

;Added hi 3/31/99
(defun make-whenever-do (n)
   (multi:new 'rule                    ; NAME:
	'whenever-do                   ; TYPE:
        n                              ; NODE:
        (new.iset)                     ; KNOWN-INSTANCES:
        (new.repset)                   ; REPORTS:
        (new.chset)                    ; REQUESTS:
        (new.feedset)                  ; INCOMING-CHANNELS:              
        (new.chset)                    ; OUTGOING-CHANNELS:
        (new.cqchset)                  ; RULE-USE-CHANNELS:
	(new.ichset)                   ; INTRODUCTION-CHANNELS:
        (new.repset)                   ; PENDING-FORWARD-INFERENCES:
        nil                            ; PRIORITY:
        'rule-handler.whenever-do      ; RULE-HANDLER:
        'usability-test.whenever-do))  ; USABILITY-TEST:


(defun make-non-rule (n)
   (multi:new 'non-rule   ; NAME:
        n                 ; NODE:
        (new.iset)        ; KNOWN-INSTANCES:
        (new.repset)      ; REPORTS:
        (new.chset)       ; REQUESTS:
        (new.feedset)     ; INCOMING-CHANNELS:
        (new.chset)       ; OUTGOING-CHANNELS:
        (new.repset)      ; PENDING-FORWARD-INFERENCES:
        nil))             ; PRIORITY:


(defun make-act (n)
   (multi:new 'act                 ; NAME:
        n                          ; NODE:
	nil			   ; CONTEXT-NAME:
	(new.repset)		   ; REPORTS:
	(new.ns)		   ; PRECONDITIONS:
	(new.ns)		   ; EFFECTS:
	(new.ns)                   ; PLANS
	nil		 	   ; AGENDA:
        nil))                      ; PRIORITY:




    
    




