;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                         State University of New York

;; Version: $Id: non-rule.lisp,v 1.7 2004/08/26 23:26:12 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; non-rule
; --------
;
;       description   : This is the node activation process for non-rule
;                       nodes.
;
;                                        written :  rgh 11/18/85
;                                        modified:  rgh  3/08/86
;                                                   rgh  3/22/86
;                                                   rgh  4/13/86
;                                                   njm  4/27/89
;
;
(defun non-rule (*NAME* *NODE* *KNOWN-INSTANCES* *REPORTS* *REQUESTS* 
		 *INCOMING-CHANNELS* *OUTGOING-CHANNELS*
		 *PENDING-FORWARD-INFERENCES* *PRIORITY*)
  (declare (special multi::curnt%))
  (catch 'Stop-Handled-by-Contradiction-Handler
    (cond (multi:*use-one-queue-only*
	   (process-reports.non-rule)
	   (process-requests.non-rule)
	   (process-forward-inferences.non-rule))
	  ((not (isnew.repset *REPORTS*))
	   (process-reports.non-rule))
	  (t (process-requests.non-rule)
	     (process-forward-inferences.non-rule))))
  (set multi::curnt% (list *NAME* *NODE* *KNOWN-INSTANCES* *REPORTS* *REQUESTS*
			   *INCOMING-CHANNELS* *OUTGOING-CHANNELS*
			   *PENDING-FORWARD-INFERENCES* *PRIORITY*)))

(setf (get 'non-rule 'multi::lregs%)
      '(*NAME* *NODE* *KNOWN-INSTANCES* *REPORTS* *REQUESTS* 
	*INCOMING-CHANNELS* *OUTGOING-CHANNELS* *PENDING-FORWARD-INFERENCES*
	*PRIORITY*))
;
;
; =============================================================================



    
    




