;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: or-ent.lisp,v 1.7 2004/08/26 23:26:13 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;  or-entailment functions
;
(defun rule-handler.v-ent (ant-report cqch)
  ;; if the antecedents have the same set of variables,
  ;; use S-indexing, otherwise use linear ruiset handling
  (let ((ruis (if (is-all-pat-same-vars (ants.cqch cqch))
		  (get-rule-use-info-sindexing ant-report cqch)
		  (get-rule-use-info ant-report cqch))))
    (do.set (rui ruis t)
      (when (and (eq (sign.rep ant-report) 'POS) (>= (poscount.rui rui) 1))
	(let ((restr (make.restr (subst.rui rui)))
	      (ch (channel.cqch cqch)))
	  (unless-remarkedp.rui
	    rui (remark '"~%Since" (makeone.ns *NODE*) nil)
	    (remark '"and" (makeone.ns (signature.rep ant-report)) restr)
	    (remark '"I infer" (makeone.ns (destination.ch ch)) restr))
	  (send-reports
	    (makeone.repset
	      (make.rep (restrict.sbst (subst.rui rui)
				       (freevars.n (destination.ch ch)))
			(compute-new-support.v-ent ch rui ant-report)
			'POS
			*NODE*
			nil
			(context.ch (channel.cqch cqch))
			))
 	    ch))))))
;
; =============================================================================
;

(defun usability-test.v-ent (sign)
  (declare (special *NODE*))
  (and (eq sign 'POS)
       (or (isnew.ns (quantified-vars.n *NODE*))
           (not (isnew.ns (nodeset.n *NODE* 'sneps::forall))))))


;
;
; =============================================================================
;
; compute-new-support.v-ent
; -------------------------
;
;       arguments     : ch  - <channel>
;                       rui - <rule-use-info>
;                       nd  - <node>
;
;       returns       : <support>
;
;       description   : receives as arguments:
;                        'rui' -- a rule use info
;                        'nd'  -- the antecedent node that has sent a report which
;                                 will permit a derivation with a new support
;                       Computes a new support based on:
;                        1- the support of the rule node if it is asserted;
;                        2- the support of the instances (of the rule) which
;                           are asserted in the 'ch' context and has the 
;                           appropriate substitution. 
;
;
;
;                                        written :  cpf/njm  10/25/88
;                                        modified: 
;
;
(defun compute-new-support.v-ent (ch rui ant-report)
  (let ((crntct (context.ch ch))
	(newsupport (new.sup))
	(freevars (freevars.n *NODE*)))
    (when (isassert.n *NODE*)
      (setq newsupport
	    (compute-new-support1.v-ent (fns.rui rui)
					(signature.rep ant-report)
					(sneps:node-asupport *NODE*))))
    (when *KNOWN-INSTANCES*
      (do.set (inst *KNOWN-INSTANCES*)
	(let* ((instnode (match::applysubst *NODE* (subst.inst inst)))
	       (supinstnode (filter.sup (sneps:node-asupport instnode) crntct)))
	  (when (and (not (isnew.sup supinstnode))
		     (match:issubset.sbst (restrict.sbst (subst.rui rui) freevars)
					  (restrict.sbst (subst.inst inst) freevars)))
	    (setq newsupport (merge.sup newsupport
					(compute-new-support1.v-ent (fns.rui rui)
								    (signature.rep ant-report)
								    supinstnode)))))))
    newsupport))

; 
;
; =============================================================================
;
; compute-new-support1.v-ent
; -------------------------
;
;       arguments     : fns - <fns>
;                       nd  - <node>
;                       sup - <support>
;
;       returns       : <support>
;
;       description   : receives as arguments:
;                        'fns' -- a flag node set
;                        'nd'  -- the antecedent node that has sent a report which
;                                 will permit a derivation with a new support
;                        'sup' -- the support of the rule node
;                       Computes a new support based on 'sup' and on the support
;                       of the 'nd' antecedent present in 'fns'
;
;
;
;                                        written :  cpf/njm  10/25/88
;                                        modified: 
;
;
(defun compute-new-support1.v-ent (fns nd sup)
  (let ((newsupport (new.sup))
	(supnd (support.fns nd fns)))
    (do* ((s1 supnd (others.sup s1))
	  (ot1 (ot.sup s1) (ot.sup s1))
	  (cts1 (ctset.sup s1) (ctset.sup s1)))
	 ((isnew.sup s1) newsupport)
      (dolist (ct1 cts1)
	(do* ((s2 sup (others.sup s2))
	      (ot2 (ot.sup s2) (ot.sup s2))
	      (cts2 (ctset.sup s2) (ctset.sup s2)))
	     ((isnew.sup s2) t)
	  (dolist (ct2 cts2)
	    (setq newsupport
		  (insert.sup (combine-ots ot1 ot2)
			      (fullbuildcontext (new.ns) (make.cts ct1 ct2))
			      newsupport))))))))





    
    




