;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1993--2004
;; Research Foundation of State University of New York

;; Version: $Id: plantrace.lisp,v 1.5 2004/08/26 23:26:13 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


(defvar *plantrace* t)

(defun plantrace (msg nodeset restriction)
  (declare (special *plantrace*))
  (cond ((null *plantrace*))
	((listp *plantrace*) (eval *plantrace*))
	((eql *plantrace* 'snepsul::surface)
	 (format t (format nil "~&~%~a" msg))
	 (mapcar #'(lambda (x) (eval `(snepsul::surface ,x)))
		 (parser::flistify nodeset)))
;	 (eval `(snepsul::surface ,@(sneps:apply-subst.ns (subst.restr restriction) nodeset)))
	(t (format t (format nil "~&~%~a" msg))
	   (cond (nodeset
		  (PP-nodetree (plantrace-desc-ns nodeset restriction)))))))

(defun plantrace-desc-ns (nodeset restriction)
  (mapcar #'(lambda (n) (plantrace-desc-one-n n restriction))
	 nodeset))

(defun plantrace-desc-one-n (node restriction)
  (let ((sbst (subst.restr restriction)))
    (cond ((is.n node)
	   (cond ((isbase.n node)
		  (cond ((isnumber.n node) (node-to-number.n node))
			(t (list node))))
		 ((isvar.n node)
		  (cond ((isbound.sbst node sbst)
			 (list node (intern "<--" *package*)
			       (cond ((eq *plantrace* 'FULL-TRACE)
				      (plantrace-desc-one-n
					(mnode.sbst node sbst)
					restriction))
				     (t (describe.n (mnode.sbst node sbst))))))
			(t node)))
		 ((or (ismol.n node) (ispat.n node))
		  (cons (describe.n node)
			(mapcar #'(lambda (c)
				    (sneps::new.c
				      (sneps::relation.c c)
				      (mapcar #'(lambda (n)
						  (plantrace-desc-one-n n restriction))
					      (sneps::nodeset.c c))))
				(n-to-downcs node))))))
	  (t node))))



    
    




