;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1993--2004
;; Research Foundation of State University of New York

;; Version: $Id: snif.lisp,v 1.6 2004/08/26 23:26:14 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;;; Representation
;;;
;;;   snif-act = action snif
;;;              object1 (list of guarded acts)


(defun snif (n)
  "Of the set of object1 act nodes,
   nondeterministically performs any one whose condition is true.
   If none are true, does nothing."
  (let ((n-act (activation.n n))
	acts)
    (case (regfetch n-act '*AGENDA*)
      (START
       (plantrace "Now doing: SNIF " (list n) nil)
       (regstore n-act '*AGENDA* 'TEST)
       (initiate n-act)
       (test-conditions n-act))
      (TEST
       (plantrace
	(format nil "~[No condition is~;This is~:;The following are~] satisfied:"
		(length *REPORTS*)) *REPORTS* nil)
       (regstore n-act '*AGENDA* 'DONE)
       (cond (*REPORTS*
	      (do.ns (report *REPORTS*)
		     (setf acts
		       (cons (choose.ns
			      #!((find then- (find object1- ~n
						   condition ~report))))
			     acts)))
	      (schedule-then-acts acts))
	     ((setf acts  #!((find (else- object1-) ~n)))
	      (schedule-act (choose.ns acts))))))))
;
;
(defun test-conditions (act-process)
  "Initiates a deduction process to determine which (if any) of the
   conditions of the SNIF act are currently believed."
  (declare (special *USER-PROCESS* *ADDED-NODES* *DEDUCTION-RESULTS*
		    CRNTCT))
  (let ((conditions (sneps::pathfrom '(snepsul::object1 snepsul::condition)
				     (regfetch act-process '*NODE* )))
	pr)
    (setq *ADDED-NODES* (new.ns))
    (setq *DEDUCTION-RESULTS* (new.ns))
    (setq *USER-PROCESS*
	  (new 'posuser
	       (new.repset)
	       crntct
	       (new.ns)
	       nil
	       nil
	       nil
	       0
	       0
	       act-process
	       'HIGH))
    (do.ns (condishun conditions)
	(activate.n condishun)
	(setq pr (activation.n condishun))
	(regstore pr '*REQUESTS*
		     (insert.chset (make.ch (new.filter)
					    (new.switch)
					    crntct
					    'user
					    'open)
				   (regfetch pr '*REQUESTS*)))
 	(regstore pr '*PRIORITY* 'LOW)
	(initiate pr))))
;
;
(defun schedule-then-acts (reports)
  (let ((act (choose.ns #2!((sneps:build
			     action ~(find-action-node 'do-one)
			     object1 ~reports))))
	act-pr)
    (plantrace "I intend to do:" (list act) nil)
    (activate-act.n act)
    (setf act-pr (activation.n act))
    (regstore act-pr '*PRIORITY* 'INTEND)
    (regstore act-pr '*AGENDA* 'START)
    (initiate act-pr)))



    
    




