;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1993--2004

;; Research Foundation of State University of New York

;; Version: $Id: sniterate.lisp,v 1.6 2004/08/26 23:26:14 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;;;
;;; Representation
;;;
;;;  sniterate-act = action sniterate
;;;                  object1 (list of guarded acts)


(defun sniterate (n)
  "Of the set of object1 act nodes,
   nondeterministically performs any one whose condition is true.
   If none are true, does the elseact if there is one, else does nothing."
  (let ((n-act (activation.n n))
	acts)
    (case (regfetch n-act '*AGENDA*)
      (START
       (plantrace "Now doing: SNITERATE " (list n) nil)
       (regstore n-act '*AGENDA* 'TEST)
       (initiate n-act)
       (test-conditions n-act))
      (TEST
       (plantrace
	(format nil "~[No condition is~;This is~:;The following are~] satisfied:"
		(length *REPORTS*)) *REPORTS* nil)
       (regstore n-act '*AGENDA* 'DONE)
       (cond (*REPORTS*
	      (do.ns (report *REPORTS*)
		     (setf acts (cons (choose.ns
				       (sneps::pathfrom
					'(condition- then)
					report)) acts)))
	      (regstore n-act '*REPORTS* (new.ns))
	      (regstore n-act '*AGENDA* 'START)
	      (schedule-then-iter-acts acts n))
	     ((setf acts  #!((find (else- object1-) ~n)))
	      (schedule-act (choose.ns acts))))))))
;

;
(defun schedule-then-iter-acts (acts iter-act)
  (let* ((do-one-act (choose.ns #2!((sneps:build
				     action ~(find-action-node 'do-one)
				     object1 ~acts))))
	 (snseq-act (choose.ns #2!((sneps:build
				    action ~(find-action-node 'snsequence)
				    object1 ~do-one-act
				    object2 ~iter-act))))
	 act-pr)
    (plantrace "I intend to do:" (list snseq-act) nil)
    (activate-act.n snseq-act)
    (setf act-pr (activation.n snseq-act))
    (regstore act-pr '*PRIORITY* 'INTEND)
    (regstore act-pr '*AGENDA* 'START)
    (initiate act-pr)))



    
    




