;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1993--2004
;; Research Foundation of State University of New York

;; Version: $Id: snsequence.lisp,v 1.7 2004/08/26 23:26:14 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

;; altered for ACL 6 compatibility (FLJ)


(in-package :snip)


;;;
;;; Representation
;;;
;;;   act = action snsequence
;;;         object1 act1
;;;	    object2 act2
;;;         ...


(defun snsequence (n)
  "Performs the objecti acts in order of i."
  (let ((i 0) acts all-acts (n-act (activation.n n)))
    ;; Use CLtL-I-style `loop':
    (regstore n-act '*AGENDA* 'DONE)
    (loop
      (incf i)
      (setq acts
        (sneps::nodeset.n n (intern 
			     (build-namestring :object i) :snepsul)))
      (if (isnew.ns acts)
          (return)
        (setf all-acts (append acts all-acts))))
    (dolist (act all-acts)
      (activate-act.n act)   
      (let ((pr (activation.n act)))
	(regstore pr '*PRIORITY* 'INTEND)
	(regstore pr '*AGENDA* 'START)
	(initiate pr)))))



    
    




