;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1993--2004
;; Research Foundation of State University of New York

;; Version: $Id: whenever-do.lisp,v 1.3 2004/08/26 23:26:14 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;  WHENEVER-DO functions
;

(defun rule-handler.whenever-do (ant-report cqch)
  ;; if the antecedents have the same set of variables,
  ;; use S-indexing, otherwise use linear ruiset handling
  (let ((ruis (if (is-all-pat-same-vars (ants.cqch cqch))
		  (get-rule-use-info-sindexing ant-report cqch)
		(get-rule-use-info ant-report cqch))))
    (do.set (rui ruis t)
	    (when (and (eq (sign.rep ant-report) 'POS)
		       (>= (poscount.rui rui) 1))
	      (let* ((restr (make.restr (subst.rui rui)))
		     (ch (channel.cqch cqch))
		     (reactionset
		      (sneps:apply-subst.ns (subst.restr restr) 
					    (makeone.ns (destination.ch ch))))
		     (reaction (choose.ns reactionset))
		     pr)
		(unless-remarkedp.rui
		 rui
		 (remark '"~%Since" (makeone.ns *NODE*) restr)
		 (remark '"and" (makeone.ns (signature.rep ant-report)) restr)
		 (remark '"I will perform" reactionset nil))
		(when (isnew.ns (nodeset.n reaction 'action))
		  (error
		   "~&The supposed ACT node ~A does not have an ACTION."
		   reaction))
		(activate-act.n reaction)
		(setq pr (activation.n reaction))
		(regstore pr '*PRIORITY* 'INTEND)
		(regstore pr '*AGENDA* 'START)		
		(multi:schedule pr multi::*act-queue*))))))


;
; =============================================================================
;

(defun usability-test.whenever-do (sign)
  (declare (special *NODE*))
  (and (eq sign 'POS)
       (or (isnew.ns (quantified-vars.n *NODE*))
           (not (isnew.ns (nodeset.n *NODE* 'sneps::forall))))))


;
;
; =============================================================================



    
    




