;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1993--2004
;; Research Foundation of State University of New York

;; Version: $Id: with-acts.lisp,v 1.7 2004/08/26 23:26:14 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;;;
;;; Representation
;;;
;;;   act = action act-node
;;;         objecti ith-argument to act-node


(defun withsome (n)
  (let ((designator (choose.ns (sneps::pathfrom '(snepsul::suchthat) n)))
	(do-act (choose.ns (sneps::pathfrom '(snepsul::do) n)))
	(with-act (activation.n n)))
    (case (regfetch with-act '*AGENDA*)
      (START
       (plantrace "Now doing: WITHSOME " (list n) nil)
       (regstore with-act '*AGENDA* 'IDENTIFY-OBJECTS)
       (initiate with-act)
       (identify-objects n designator))
      (IDENTIFY-OBJECTS
       (let ((reports (remove-if-not #'isassert.n *REPORTS*)))
	 (regstore with-act '*AGENDA* 'DONE)
	 (cond (reports
		;;(plantrace "The designator(s):" *REPORTS* nil)
		(schedule-withsome-act designator do-act reports))
	       (t (plantrace "No designators found!" nil nil)
		  (let ((acts  #!((find else- ~n))))
		    (when acts
		      (schedule-act (choose.ns acts)))))))))))
;
;
(defun identify-objects (act designator)
  (declare (special *USER-PROCESS* *ADDED-NODES* *DEDUCTION-RESULTS*
			    CRNTCT))
  (let (pr)
    (setq *ADDED-NODES* (new.ns))
    (setq *DEDUCTION-RESULTS* (new.ns))
    (setq *USER-PROCESS*
	  (new 'posuser
	       (new.repset)
	       crntct
	       (new.ns)
	       nil
	       nil
	       nil
	       0
	       0
	       (activation.n act)
	       'HIGH))
    (activate.n designator)
    (setq pr (activation.n designator))
    (regstore pr '*REQUESTS*
	         (insert.chset (make.ch (new.filter)
					(new.switch)
					crntct
					;*NODE*
					'user
					'open)
			        (regfetch pr '*REQUESTS*)))
    (regstore pr '*PRIORITY* 'LOW)
    (initiate pr)))

(defun posuser (*NAME* *REPORTS* *CONTEXT-NAME* *DEDUCED-NODES* *TOTAL-DESIRED*
	     *POS-DESIRED* *NEG-DESIRED* *POS-FOUND* *NEG-FOUND*
		*CLIENT* *PRIORITY*)
  "Like the user process function, but only collects positive answers."
  (declare (special multi::curnt%))
  (let ((reports *REPORTS*))
    (setq *REPORTS* (new.repset))
    (do.repset (report reports)
       (let ((n (node.rep report)))
	 (unless (or (ismemb.ns n *DEDUCED-NODES*)
		     (not (eq (sign.rep report) 'POS)))
		 (tally report)
		 (setq *DEDUCED-NODES* (insert.ns n *DEDUCED-NODES*))))))
  (setq *DEDUCTION-RESULTS* (union.ns *DEDUCED-NODES* *DEDUCTION-RESULTS*))
    (if (not (eq *CLIENT* 'snip::user))            ;; *CLIENT* can be a node
      (send-to-client *CLIENT* *DEDUCED-NODES*))
  (if (enough-answers) (suspend-inference))
  (set multi::curnt% (list *NAME* *REPORTS* *CONTEXT-NAME* *DEDUCED-NODES*
			   *TOTAL-DESIRED* *POS-DESIRED* *NEG-DESIRED*
			   *POS-FOUND* *NEG-FOUND* *CLIENT* *PRIORITY*)))

(setf (get 'posuser 'multi::lregs%)
  '(*NAME* *REPORTS* *CONTEXT-NAME* *DEDUCED-NODES* *TOTAL-DESIRED*
    *POS-DESIRED* *NEG-DESIRED* *POS-FOUND* *NEG-FOUND*
    *CLIENT* *PRIORITY*))
;
;
(defun schedule-withsome-act (designator do-act reports)
  (let ((acts (new.ns))
	substs)
    (plantrace "The designator" (list designator) nil)
    (plantrace "is effective on the following:" reports nil)
    (plantrace "for the act:" (list do-act) nil)
    (do.ns (report reports)
	   (setf substs (first (first (match::unify designator report))))
	   (setf acts (cons (match::applysubst do-act substs) acts))
	   ;(plantrace "The substitutions are:" (list substs) nil)
	   ;(plantrace "The act is:" acts nil)
	   )
    (schedule-then-acts acts)))
;
;
(defun withall (n)
  (let ((designator (choose.ns (sneps::pathfrom '(snepsul::suchthat) n)))
	(do-act (choose.ns (sneps::pathfrom '(snepsul::do) n)))
	(with-act (activation.n n)))
    (case (regfetch with-act '*AGENDA*)
      (START
       (plantrace "Now doing: WITHALL " (list n) nil)
       (regstore with-act '*AGENDA* 'IDENTIFY-OBJECTS)
       (initiate with-act)
       (identify-objects n designator))
      (IDENTIFY-OBJECTS
       (let ((reports (remove-if-not #'isassert.n *REPORTS*)))
	 (regstore with-act '*AGENDA* 'DONE)
	 (cond (reports
		;;(plantrace "The designator(s):" *REPORTS* nil)
		(schedule-withall-act designator do-act reports))
	       (t (plantrace "No designators found!" nil nil)
		  (let ((acts  #!((find else- ~n))))
		    (when acts
		      (schedule-act (choose.ns acts)))))))))))
;
;
(defun schedule-withall-act (designator do-act reports)
  (let ((acts (new.ns))
	substs)
    (plantrace "The designator" (list designator) nil)
    (plantrace "is effective on the following:" reports nil)
    (plantrace "for the act:" (list do-act) nil)
    (do.ns (report reports)
	   (setf substs (first (first (match::unify designator report))))
	   (setf acts (cons (match::applysubst do-act substs) acts))
	   ;(plantrace "The substitutions are:" (list substs) nil)
	   ;(plantrace "The act is:" acts nil)
	   )
    (schedule-doall-acts acts)))
;
;
(defun schedule-doall-acts (reports)
  (let ((act (choose.ns
	      #2!((sneps:build snepsul::action ~(find-action-node 'do-all)
			       snepsul::object1 ~reports))))
	act-pr)
    (plantrace "I intend to do:" (list act) nil)
    (activate-act.n act)
    (setf act-pr (activation.n act))
    (regstore act-pr '*PRIORITY* 'INTEND)
    (regstore act-pr '*AGENDA* 'START)
    (initiate act-pr)))



    
    




