;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: XGINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004 Research Foundation of 
;;                          State University of New York

;; Version: $Id: node.lisp,v 1.8 2004/08/26 23:26:21 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :xginseng)


;;;; This file contains the definition of a graphical node data type. 


;; Define constants for the parameters of the graphic node.
(defconstant *nodeheight* 30 "Height of the node")
(defconstant *halfnodeheight* 15 "One-half the height of the node")
(defconstant *textnodeleft* 8 
  "Place node's name this number of pixels from the left edge of the node")
(defconstant *textnodetop* 8
  "Place node's name this number of pixels from the top of the node")
(defconstant *newnodeleft* 10 "Initial value of :left for a new node")
(defconstant *newnodetop* 10 "Initial value of :top for a new node")

(setf kr::*print-new-instances* nil)


;; Create a prototype for the node, consisting of the node name within
;; a roundtangle, and a text interactor.
(create-instance 'NODE opal:aggregadget
 (:prototype 'node)		 
 (:alter-ego nil)
 (:box (list 0 0))
 (:left (o-formula (first (gvl :box))))
 (:top (o-formula (second (gvl :box))))
 (:assert-node-p nil); my-change
 (:base-node-p nil)
 (:pattern-node-p nil)
 (:name "")
 (:name-symbol (o-formula 
		(if (eq (char 
			 (string-trim 
			  '(#\newline #\space #\tab) 
			  (gvl :text :string)) 
			 0) 
			#\")
		    (intern
		     (string-trim '(#\") 
				  (string-trim 
				   '(#\newline #\space #\tab) 
				   (gvl :text :string))))
		  (intern 
		   (string-upcase 
		    (string-trim '(#\newline #\space #\tab)
				 (gvl :text :string))))))); my-change
 (:sneps-command nil); my-change
 (:parent-node nil) ;my-change
 (:children nil) ;my-change 
 (:sneps-node NIL) ;The sneps node associated with this Garnet node
 (:up-cables NIL)  ;  Garnet cables pointing TO this node
 (:down-cables NIL) ; Cables pointing FROM this node.
 ;; non-customizable components
 (:parts
  `((:frame ,opal:oval
	    (:left ,(o-formula (gv (kr-path 0 :parent) :left)))
	    (:top ,(o-formula (gv (kr-path 0 :parent) :top)))
	    (:height ,(o-formula *nodeheight*))
	    (:width ,(o-formula (max *nodeheight* 
				     (+ 
				      (gv (kr-path 0 :parent) :text :width) 
				      *halfnodeheight*))))
            ;;needed to "blank-out" underlying lines; using o-formula instead
            ;;of just opal:white-fill makes this slot changeable without 
            ;;changing other nodes with it.
            (:filling-style ,(o-formula opal:white-fill)))
    (:text ,opal:cursor-text
	   (:left ,(o-formula 
		    (if (< (gv (kr-path 0 :parent) :text :width)
			   (- (gv (kr-path 0 :parent) :frame :width)
			      *textnodeleft* *textnodeleft*))
			(+ (gv (kr-path 0 :parent) :frame :left)
			   (- *halfnodeheight*
			      (floor (gv (kr-path 0 :parent) :text :width) 2)))
		      (+ (gv (kr-path 0 :parent) :left) *textnodeleft*))))
	   (:top ,(o-formula (+ (gv (kr-path 0 :parent) :top) *textnodetop*)))
	   (:cursor-index NIL)
	   (:string ,(o-formula (gv (kr-path 0 :parent) :name)))))))





(defun display-node (string-name)
  "Retrieves the symbols corresponding to <string-name> in the packages
XGinseng and Snepsul.  If the node is already on the display, it is
REDISPLAYED; if not displayed, and a sneps node exists in the Snepsul
package, then a new node is built, and sent to NODE-PLACER for placement
on the display screen. Else, an error message is sent."
  (let ((xg-symbol (intern string-name 'xginseng))
	(snepsul-symbol (intern string-name 'snepsul)))
    (cond ((on-display-p xg-symbol) ; Node was hidden and 
	   (redisplay (eval xg-symbol))) ;is now being REDISPLAYED
	  ((sneps:node snepsul-symbol) ; New node to be built
	   ;; Store <xg-symbol> and <sneps-node> in NODE-PLACER
	   ;; for use in building the new node with NEW-NODE
	   (s-value node-placer :node-symbol xg-symbol)
	   (s-value node-placer :sneps-node (sneps:node snepsul-symbol))
	   (opal:remove-components dialogue-aggregate prompt reply)
	   (opal:add-component dialogue-aggregate click-prompt)
	   (opal:update dialogue-window)
	   (inter:beep))
	  (t (error-message "There is no current SNePS node named ~a" string-name)))))

(defun new-node (xg-symbol sneps-node coordinates)
  "Creates a new XGinseng node with name <xg-symbol>, storing <sneps-node>
in :sneps-node, at <coordinates>; Adds it to the Display window, and returns
the new object."
  (declare (special display-aggregate))
  (create-instance xg-symbol (eval node)
		   (:box coordinates)
		   (:name (format nil "~A" sneps-node))
		   (:down-cables NIL)
		   (:up-cables NIL)
		   (:alter-ego (o-formula (gv :self)))
		   (:sneps-node sneps-node))
  (push (eval xg-symbol) (g-value display-window :nodes-on-display))
  (opal:add-component display-aggregate (eval xg-symbol)))

(defun redisplay (xg-node)
  (s-value xg-node :visible t)
  (error-message "Node ~a has been displayed" (g-value xg-node :name))
  ;; If the node has an immediate descendant or ancestor visible in
  ;; the display window, then redescribe it.
  (if (dolist (cable (g-value xg-node :down-cables))
	      (when (g-value (get-node cable) :visible)
		    (return t)))
      (dolist (cable (g-value xg-node :down-cables))
	      (s-value (get-arc cable) :visible t)
	      (s-value (get-node cable) :visible t)))
  (if (dolist (cable (g-value xg-node :up-cables))
	      (when (g-value (get-node cable) :visible)
		    (return t)))
      (dolist (cable (g-value xg-node :up-cables))
	      (s-value (get-arc cable) :visible t)
	      (s-value (get-node cable) :visible t)))
  (opal:update display-window))




    
    




