;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: XGINSENG; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: toplevel.lisp,v 1.13 2004/08/26 23:26:21 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :xginseng)


;;;;    Contains definition of the top-level xginseng function


(defun xginseng-loaded-p ()
  (fboundp 'xginseng1))

(sneps:defsnepscom xginseng (())
  "Top-level function.  If XGinseng is already running, restarts it;
else, loads proper files and calls XGINSENG1."
  (unless (xginseng-loaded-p)
    ;; Try to load it, this will print an error message and
    ;; return if Xginseng can't be loaded because Garnet is not installed.
    (user:sneps-load "sneps:xginseng;load-xginseng.LISP"))
  (when (xginseng-loaded-p)
    ;; If we successfully loaded Xginseng, run it:
    (if (boundp 'display-window)
	(restart)
      (xginseng1))))

;; Since we can't rely on `declaim' being available do this instead:
(eval-when (eval compile load)

  ;; Declare some variables:
  (proclaim '(special *totaldisplayheight* *totaldisplaywidth*))

  ;; Declare the various XGinseng/Garnet objects as special:
  (proclaim '(special
	      andor-inter_panel
	      assert-build-toggle-inter_panel
	      button-window
	      click-prompt
	      click-prompt
	      create_blank_arc_inter_panel
	      create_blank_double_arc_inter_panel
	      create_blank_node_inter_panel
	      dialogue-aggregate
	      dialogue-window
	      display-window
	      error-priority-level
	      error-text
	      file-prompt
	      get-text-of-relation-inter_panel
	      help-window
	      input-button-window
	      main-button-panel
	      main-button-panel-2
	      make-a-base-node-inter_panel
	      make-a-base-pattern-inter_panel
	      moving-arrow-line
	      moving-oval
	      node-or-arc-deletor_panel
	      node-placer
	      node-selector_all-ancestors-node
	      node-selector_all-descendants-node
	      node-selector_assert-node
	      node-selector_describe-down-node
	      node-selector_describe-up-node
	      node-selector_erase-node
	      node-selector_hide-node
	      numerical-entailment-inter_panel
	      prompt
	      put-text-of-relation-inter
	      put-text-of-relation-inter_panel
	      put-text-of-relation-inter_panel
	      reply
	      reply-inter
	      text-inter_panel
	      thresh-inter_panel
	      universal-quantifier-inter_panel
	      ))

  ) ;; end of eval-when



    
    




