/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JLWrapper;
import com.franz.jlinker.JavaLinkDist;
import com.franz.jlinker.LispCall;
import com.franz.jlinker.LispCallImplementation;
import com.franz.jlinker.TranStruct;

class LispCallSocket
extends LispCallImplementation {
    static Class opclass = null;
    LispCall lci;

    Class getOpClass() {
        return opclass;
    }

    LispCallSocket() {
    }

    LispCallImplementation builder(LispCall lispCall, int n, boolean bl, String string) {
        LispCallSocket lispCallSocket = new LispCallSocket();
        lispCallSocket.lci = lispCall;
        if (!string.equals("")) {
            lispCall.lispOp = JavaLinkDist.newDistOb(string);
        }
        return lispCallSocket;
    }

    void setOp(String string) {
        this.setOp(JavaLinkDist.newDistOb(string));
    }

    void setOp(Object object) {
        this.lci.lispOp = object;
        if (this.lci.state == 0) {
            this.lci.state = 1;
        }
    }

    synchronized int addArgWrapped(TranStruct tranStruct) {
        if (this.lci.state != 1) {
            throw new IllegalArgumentException("Wrong state");
        }
        return this.lci.newHolder(tranStruct);
    }

    synchronized int addArg(int n) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(n));
    }

    synchronized int addArg(short s) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(s));
    }

    synchronized int addArg(byte by) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(by));
    }

    synchronized int addArg(long l) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(l));
    }

    synchronized int addArg(boolean bl) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(bl));
    }

    synchronized int addArg(int[] nArray) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(nArray));
    }

    synchronized int addArg(short[] sArray) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(sArray));
    }

    synchronized int addArg(byte[] byArray) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(byArray));
    }

    synchronized int addArg(String string) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(string));
    }

    synchronized int addArg(String[] stringArray) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(stringArray));
    }

    synchronized int addArg(double d) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(d));
    }

    synchronized int addArg(float f) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(f));
    }

    synchronized int addArg(double[] dArray) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(dArray));
    }

    synchronized int addArg(float[] fArray) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(fArray));
    }

    synchronized int addArg(Object object) {
        if (opclass.isInstance(object)) {
            return this.addArgWrapped((TranStruct)object);
        }
        return this.addArgWrapped(JavaLinkDist.newDistOb(object));
    }

    synchronized int addSymbol(String string) {
        return this.addArgWrapped(JavaLinkDist.newDistSym(string, "", 0));
    }

    synchronized int addSymbol(String string, String string2) {
        return this.addArgWrapped(JavaLinkDist.newDistSym(string, string2, 0));
    }

    synchronized int addSymbol(String string, String string2, int n) {
        return this.addArgWrapped(JavaLinkDist.newDistSym(string, string2, n));
    }

    synchronized void assemble(String string) {
        TranStruct[] tranStructArray;
        if (this.lci.state != 1) {
            this.lci.throwWrongState(string, "");
        }
        this.lci.args = tranStructArray = new TranStruct[this.lci.count];
        for (int i = 0; i < this.lci.count; ++i) {
            tranStructArray[this.lci.count - i - 1] = (TranStruct)this.lci.chain.arg;
            this.lci.chain = this.lci.chain.next;
        }
        this.lci.count = 0;
        this.lci.state = 2;
    }

    synchronized int call() throws JavaLinkDist.JLinkerException {
        TranStruct[] tranStructArray;
        if (this.lci.state == 1) {
            this.assemble("call");
        }
        if (this.lci.state != 2) {
            this.lci.throwWrongState("call", "");
        }
        this.lci.res = tranStructArray = JavaLinkDist.invokeInLispEx(this.lci.callStyle, (TranStruct)this.lci.lispOp, (TranStruct[])this.lci.args);
        if (!this.lci.retain) {
            this.lci.args = null;
        }
        if (this.lci.callStyle >= 3) {
            this.lci.waitref = tranStructArray[1];
            this.lci.res = null;
            this.lci.state = 4;
            return 0;
        }
        this.lci.waitref = null;
        this.lci.state = 3;
        if (tranStructArray.length == 0) {
            return 0;
        }
        return JavaLinkDist.intValue(tranStructArray[0]);
    }

    synchronized Object getValue(int n) {
        TranStruct[] tranStructArray = (TranStruct[])this.lci.res;
        TranStruct tranStruct = tranStructArray[n + 1];
        if (tranStruct == null) {
            this.lci.throwWrongState("getValue", "when value already retrieved once");
        }
        if (!this.lci.retain) {
            tranStructArray[n + 1] = null;
        }
        return tranStruct;
    }

    int typeOf(Object object) {
        TranStruct tranStruct = (TranStruct)object;
        if (JavaLinkDist.nullP(tranStruct)) {
            return 0;
        }
        if (JavaLinkDist.booleanP(tranStruct)) {
            return 1;
        }
        if (JavaLinkDist.longP(tranStruct)) {
            return 3;
        }
        if (JavaLinkDist.integerP(tranStruct)) {
            return 2;
        }
        if (JavaLinkDist.realP(tranStruct)) {
            return 4;
        }
        if (JavaLinkDist.errorP(tranStruct)) {
            return 13;
        }
        if (JavaLinkDist.symbolP(tranStruct)) {
            return 11;
        }
        if (JavaLinkDist.stringP(tranStruct)) {
            return 5;
        }
        Object object2 = JavaLinkDist.pointerValue(tranStruct);
        if (object2 == tranStruct) {
            return 12;
        }
        String string = object2.getClass().getName();
        if (string.equals("[I")) {
            return 21;
        }
        if (string.equals("[D")) {
            return 22;
        }
        if (string.equals("[Ljava.lang.String;")) {
            return 23;
        }
        return 24;
    }

    synchronized int typeOf(int n) {
        TranStruct[] tranStructArray = (TranStruct[])this.lci.res;
        if (n + 1 >= tranStructArray.length) {
            return 92;
        }
        return this.typeOf(this.getValue(n));
    }

    TranStruct getValueTr(int n) {
        return (TranStruct)this.getValue(n);
    }

    synchronized int intValue(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        if (JavaLinkDist.integerP(tranStruct)) {
            return JavaLinkDist.intValue(tranStruct);
        }
        throw new UnsupportedOperationException("intValue of " + LispCall.nameOfType(this.typeOf(tranStruct)));
    }

    synchronized long longValue(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        if (JavaLinkDist.longP(tranStruct)) {
            return JavaLinkDist.longValue(tranStruct);
        }
        if (JavaLinkDist.integerP(tranStruct)) {
            return JavaLinkDist.intValue(tranStruct);
        }
        throw new UnsupportedOperationException("longValue of " + LispCall.nameOfType(this.typeOf(tranStruct)));
    }

    synchronized double doubleValue(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        if (JavaLinkDist.realP(tranStruct)) {
            return JavaLinkDist.doubleValue(tranStruct);
        }
        throw new UnsupportedOperationException("doubleValue of " + LispCall.nameOfType(this.typeOf(tranStruct)));
    }

    synchronized boolean booleanValue(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        if (JavaLinkDist.booleanP(tranStruct)) {
            return JavaLinkDist.boolValue(tranStruct);
        }
        throw new UnsupportedOperationException("booleanValue of " + LispCall.nameOfType(this.typeOf(tranStruct)));
    }

    synchronized String stringValue(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        if (JavaLinkDist.stringP(tranStruct)) {
            return JavaLinkDist.stringValue(tranStruct);
        }
        throw new UnsupportedOperationException("stringValue of " + LispCall.nameOfType(this.typeOf(tranStruct)));
    }

    synchronized int[] intArrayValue(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        int n2 = this.typeOf(tranStruct);
        if (n2 == 21) {
            return (int[])JavaLinkDist.pointerValue(tranStruct);
        }
        throw new UnsupportedOperationException("intArrayValue of " + LispCall.nameOfType(n2));
    }

    synchronized String[] stringArrayValue(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        int n2 = this.typeOf(tranStruct);
        if (n2 == 23) {
            return (String[])JavaLinkDist.pointerValue(tranStruct);
        }
        throw new UnsupportedOperationException("stringArrayValue of " + LispCall.nameOfType(n2));
    }

    synchronized double[] doubleArrayValue(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        int n2 = this.typeOf(tranStruct);
        if (n2 == 22) {
            return (double[])JavaLinkDist.pointerValue(tranStruct);
        }
        throw new UnsupportedOperationException("doubleArrayValue of " + LispCall.nameOfType(n2));
    }

    synchronized Object objectValue(int n) {
        Object object;
        TranStruct tranStruct = this.getValueTr(n);
        if (JavaLinkDist.pointerP(tranStruct) && (object = JavaLinkDist.pointerValue(tranStruct)) != tranStruct) {
            return object;
        }
        throw new UnsupportedOperationException("objectValue of " + LispCall.nameOfType(this.typeOf(tranStruct)));
    }

    synchronized String symbolName(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        if (JavaLinkDist.symbolP(tranStruct)) {
            return JavaLinkDist.symbolName(tranStruct);
        }
        throw new UnsupportedOperationException("symbolName of " + LispCall.nameOfType(this.typeOf(tranStruct)));
    }

    synchronized String symbolPackage(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        if (JavaLinkDist.symbolP(tranStruct)) {
            return JavaLinkDist.symbolPackage(tranStruct);
        }
        throw new UnsupportedOperationException("symbolPackage of " + LispCall.nameOfType(this.typeOf(tranStruct)));
    }

    synchronized String lispType(int n) {
        TranStruct tranStruct = this.getValueTr(n);
        if (JavaLinkDist.pointerP(tranStruct) && tranStruct == JavaLinkDist.pointerValue(tranStruct)) {
            return JavaLinkDist.stringValue(tranStruct);
        }
        return LispCall.nameOfType(this.typeOf(tranStruct));
    }

    synchronized int query(boolean bl, boolean bl2) throws JavaLinkDist.JLinkerException {
        TranStruct[] tranStructArray = null;
        if (this.lci.res != null) {
            tranStructArray = (TranStruct[])this.lci.res;
        }
        switch (this.lci.state) {
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                return -100;
            }
            case 3: {
                if (this.lci.res == null) {
                    return -99;
                }
                if (tranStructArray.length == 0) {
                    return 0;
                }
                return JavaLinkDist.intValue(tranStructArray[0]);
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                return -100;
            }
        }
        if (this.lci.waitref == null) {
            return -100;
        }
        if (bl && this.lci.state == 4) {
            this.lci.res = tranStructArray = JavaLinkDist.invokeInLispEx(2, JavaLinkDist.newDistOb("cl:car"), new TranStruct[]{(TranStruct)this.lci.waitref});
            int n = JavaLinkDist.intValue(tranStructArray[1]);
            if (n >= 0) {
                this.lci.waitres = n;
                this.lci.state = 5;
            } else if (n == -98) {
                this.lci.waitres = n;
                this.lci.res = null;
                this.lci.state = 5;
            } else if (n == -99) {
                this.lci.res = null;
                this.lci.state = 3;
                return -99;
            }
        }
        if (bl2 && this.lci.state == 5) {
            this.lci.res = tranStructArray = JavaLinkDist.invokeInLispEx(2, JavaLinkDist.newDistOb("javatools.jlinker::jl-async-results"), new TranStruct[]{(TranStruct)this.lci.waitref});
            this.lci.state = 3;
            if (this.lci.res == null) {
                return 0;
            }
            if (((TranStruct[])this.lci.res).length == 0) {
                return 0;
            }
            return JavaLinkDist.intValue(tranStructArray[0]);
        }
        if (this.lci.state == 5) {
            if (bl) {
                return this.lci.waitres;
            }
            return -11;
        }
        return -10;
    }

    synchronized void close() {
    }

    synchronized void reset() {
    }

    synchronized void setArgWrapped(int n, JLWrapper jLWrapper) {
        TranStruct tranStruct = (TranStruct)jLWrapper;
        switch (this.lci.state) {
            case 1: {
                this.assemble("setArg");
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.lci.throwWrongState("setArg", "");
            }
        }
        ((TranStruct[])this.lci.args)[n] = tranStruct;
    }

    synchronized void setArg(int n, boolean bl) {
        this.setArgWrapped(n, JavaLinkDist.newDistOb(bl));
    }

    synchronized void setArg(int n, int n2) {
        this.setArgWrapped(n, JavaLinkDist.newDistOb(n2));
    }

    synchronized void setArg(int n, long l) {
        this.setArgWrapped(n, JavaLinkDist.newDistOb(l));
    }

    synchronized void setArg(int n, double d) {
        this.setArgWrapped(n, JavaLinkDist.newDistOb(d));
    }

    synchronized void setArg(int n, String string) {
        this.setArgWrapped(n, JavaLinkDist.newDistOb(string));
    }

    synchronized void setArg(int n, Object object) {
        if (opclass.isInstance(object)) {
            this.setArgWrapped(n, (JLWrapper)object);
        } else {
            this.setArgWrapped(n, JavaLinkDist.newDistOb(object));
        }
    }

    synchronized void setArg(int n, int[] nArray) {
        this.setArgWrapped(n, JavaLinkDist.newDistOb(nArray));
    }

    synchronized void setArg(int n, double[] dArray) {
        this.setArgWrapped(n, JavaLinkDist.newDistOb(dArray));
    }

    synchronized void setArg(int n, String[] stringArray) {
        this.setArgWrapped(n, JavaLinkDist.newDistOb(stringArray));
    }

    synchronized void setSymbol(int n, String string) {
        this.setArg(n, JavaLinkDist.newDistSym(string, "", 0));
    }

    synchronized void setSymbol(int n, String string, String string2) {
        this.setArg(n, JavaLinkDist.newDistSym(string, string2, 0));
    }

    synchronized void setSymbol(int n, String string, String string2, int n2) {
        this.setArg(n, JavaLinkDist.newDistSym(string, string2, n2));
    }

    int mayCall() {
        return 2;
    }

    static {
        try {
            opclass = Class.forName("com.franz.jlinker.TranStruct");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

