/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import edu.uci.ics.jung.algorithms.flows.EdmondsKarpMaxFlow;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.NumericDecorator;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.statistics.DegreeDistributions;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.MutableInteger;
import edu.uci.ics.jung.utils.UserData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ExactFlowCommunity {
    private int mCohesionThreshold;

    public ExactFlowCommunity(int cohesionThreshold) {
        this.mCohesionThreshold = cohesionThreshold;
    }

    public Set extract(DirectedGraph graph, Set rootSet) {
        DirectedGraph flowGraph = (DirectedGraph)graph.copy();
        Vertex source = flowGraph.addVertex(new SparseVertex());
        Vertex sink = flowGraph.addVertex(new SparseVertex());
        this.initializeFlowGraph(flowGraph, source, sink, rootSet);
        EdmondsKarpMaxFlow maxFlowSolver = new EdmondsKarpMaxFlow(flowGraph, source, sink, "CAPACITY", "FLOW");
        maxFlowSolver.evaluate();
        HashSet<ArchetypeVertex> communityVertices = new HashSet<ArchetypeVertex>();
        Set sourceNodes = maxFlowSolver.getNodesInSourcePartition();
        Iterator vIt = sourceNodes.iterator();
        while (vIt.hasNext()) {
            Vertex v = (Vertex)vIt.next();
            if (v.getEqualVertex(flowGraph) == source) continue;
            communityVertices.add(v.getEqualVertex(graph));
        }
        return communityVertices;
    }

    public static Set extract(DirectedGraph graph, Set rootSet, int numIterations) {
        ExactFlowCommunity ecf;
        HashSet<Vertex> members = new HashSet<Vertex>(rootSet);
        Set newMembers = null;
        int numPreviousMembers = members.size();
        int numCurrentMembers = 0;
        for (int i = 0; i < numIterations && numPreviousMembers != (numCurrentMembers = (newMembers = (ecf = new ExactFlowCommunity(members.size())).extract(graph, members)).size()); ++i) {
            numPreviousMembers = numCurrentMembers;
            System.out.println(members.size());
            DoubleArrayList inDegrees = DegreeDistributions.getIndegreeValues(newMembers);
            int maxIndegree = (int)Descriptive.max((DoubleArrayList)inDegrees);
            DoubleArrayList outDegrees = DegreeDistributions.getOutdegreeValues(newMembers);
            int maxOutdegree = (int)Descriptive.max((DoubleArrayList)outDegrees);
            Iterator vIt = newMembers.iterator();
            while (vIt.hasNext()) {
                Vertex v = (Vertex)vIt.next();
                if (members.contains(v)) continue;
                if (v.inDegree() == maxIndegree) {
                    members.add(v);
                    continue;
                }
                if (v.outDegree() != maxOutdegree) continue;
                members.add(v);
            }
        }
        return newMembers;
    }

    protected void initializeFlowGraph(DirectedGraph flowGraph, Vertex source, Vertex sink, Set rootSet) {
        NumericDecorator capacityDecorator = new NumericDecorator("CAPACITY", UserData.SHARED);
        ArrayList edgesList = new ArrayList();
        edgesList.addAll(flowGraph.getEdges());
        for (int idx = 0; idx < edgesList.size(); ++idx) {
            DirectedEdge currentEdge = (DirectedEdge)edgesList.get(idx);
            capacityDecorator.setValue(new MutableInteger(this.mCohesionThreshold), currentEdge);
            Edge otherEdge = currentEdge.getDest().findEdge(currentEdge.getSource());
            if (otherEdge != null) continue;
            otherEdge = GraphUtils.addEdge(flowGraph, currentEdge.getDest(), currentEdge.getSource());
            capacityDecorator.setValue(new MutableInteger(this.mCohesionThreshold), otherEdge);
        }
        Iterator vIt = flowGraph.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            if (currentVertex == sink || rootSet.contains(currentVertex)) continue;
            Edge newEdge = GraphUtils.addEdge(flowGraph, currentVertex, sink);
            capacityDecorator.setValue(new MutableInteger(1), newEdge);
        }
        Iterator rootIt = rootSet.iterator();
        while (rootIt.hasNext()) {
            Vertex currentRoot = (Vertex)rootIt.next();
            currentRoot = (Vertex)currentRoot.getEqualVertex(flowGraph);
            Edge e = GraphUtils.addEdge(flowGraph, source, currentRoot);
            capacityDecorator.setValue(new MutableInteger(Integer.MAX_VALUE), e);
        }
    }
}

