/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.transform.AbstractLensSupport;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.TransformingPluggableRenderer;
import java.awt.Dimension;

public class ViewLensSupport
extends AbstractLensSupport
implements LensSupport {
    protected PluggableRenderer pluggableRenderer;
    protected TransformingPluggableRenderer transformingPluggableRenderer;
    protected Renderer renderer;

    public ViewLensSupport(VisualizationViewer vv) {
        this(vv, new HyperbolicShapeTransformer(vv), new ModalLensGraphMouse());
    }

    public ViewLensSupport(VisualizationViewer vv, LensTransformer lensTransformer, ModalGraphMouse lensGraphMouse) {
        super(vv, lensGraphMouse);
        this.renderer = vv.getRenderer();
        this.lensTransformer = lensTransformer;
        Dimension d = vv.getSize();
        if (d.width == 0 || d.height == 0) {
            d = vv.getPreferredSize();
        }
        lensTransformer.setViewRadius(d.width / 5);
        this.pluggableRenderer = this.renderer instanceof PluggableRenderer ? (PluggableRenderer)this.renderer : new PluggableRenderer();
    }

    public void activate() {
        if (this.lens == null) {
            this.lens = new AbstractLensSupport.Lens(this.lensTransformer);
        }
        if (this.lensControls == null) {
            this.lensControls = new AbstractLensSupport.LensControls(this.lensTransformer);
        }
        this.vv.setViewTransformer(this.lensTransformer);
        if (this.transformingPluggableRenderer == null) {
            this.transformingPluggableRenderer = new TransformingPluggableRenderer(this.pluggableRenderer);
        }
        this.transformingPluggableRenderer.setTransformer(this.lensTransformer);
        this.vv.setRenderer(this.transformingPluggableRenderer);
        this.vv.addPreRenderPaintable(this.lens);
        this.vv.addPostRenderPaintable(this.lensControls);
        this.vv.setGraphMouse(this.lensGraphMouse);
        this.vv.setToolTipText("<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>");
        this.vv.repaint();
    }

    public void deactivate() {
        this.vv.setViewTransformer(this.savedViewTransformer);
        this.vv.removePreRenderPaintable(this.lens);
        this.vv.removePostRenderPaintable(this.lensControls);
        this.vv.setRenderer(this.renderer);
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setGraphMouse(this.graphMouse);
        this.vv.repaint();
    }
}

