/*
 * SNePSGUIShow.java
 *
 * Created on August 8, 2006, 12:30 PM
 */

/**
 *
 * @author  Michael Kandefer
 */
import com.franz.jlinker.JavaLinkDist;
import edu.uci.ics.jung.graph.decorators.AbstractVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.ConstantVertexSizeFunction;
import edu.uci.ics.jung.graph.decorators.ConstantVertexAspectRatioFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeStringer;
import edu.uci.ics.jung.graph.decorators.EllipseVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.ViewScalingControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.*;
import javax.swing.filechooser.*;
import javax.swing.tree.*;
import edu.uci.ics.jung.graph.*;
import edu.uci.ics.jung.graph.impl.*;
import edu.uci.ics.jung.visualization.*;
import com.franz.jlinker.LispCall;
import com.franz.jlinker.LispConnector;
import edu.uci.ics.screencap.EPSDump;


public class SNePSGUIShow extends javax.swing.JFrame {
    
    private JFileChooser fc;
    private JFileChooser imageChooser;
    private SparseGraph testGraph;
    private Layout l;
    private VisualizationViewer vv;
    private PluggableRenderer pr;
    private LispConnector lc;
    private ArrayList predicates; 
    private ScalingControl scaler;
    private Socket snepsMsgSocket;
    private BufferedReader snepsMsgStream;
    private File loadedFile;
 
    private File workingImagePath;
    private File workingSnepsPath;

    public final static int VERTICAL_OFFSET = 10;
            

    private boolean include_eps_support = false;
    
    /** Creates new form SNePSGUI */
    public SNePSGUIShow(boolean eps) {
	include_eps_support = eps;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        SaveAsMenu = new javax.swing.JPopupMenu();
        SaveImageItem = new javax.swing.JMenuItem();
        jNetworkDrawPanel = new javax.swing.JPanel();

        SaveAsMenu.addMouseListener(new java.awt.event.MouseAdapter() {
		public void mouseEntered(java.awt.event.MouseEvent evt) {
		    SaveAsMenuMouseEntered(evt);
		}
		public void mouseExited(java.awt.event.MouseEvent evt) {
		    SaveAsMenuMouseExited(evt);
		}
	    });

        SaveImageItem.setText("Save Image As...");
        SaveImageItem.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(java.awt.event.ActionEvent evt) {
		    SaveImageItemActionPerformed(evt);
		}
	    });
        SaveImageItem.addMouseListener(new java.awt.event.MouseAdapter() {
		public void mouseEntered(java.awt.event.MouseEvent evt) {
		    SaveImageItemMouseEntered(evt);
		}
		public void mouseExited(java.awt.event.MouseEvent evt) {
		    SaveImageItemMouseExited(evt);
		}
	    });

        SaveAsMenu.add(SaveImageItem);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("SNePS show output");
        addComponentListener(new java.awt.event.ComponentAdapter() {
		public void componentResized(java.awt.event.ComponentEvent evt) {
		    formComponentResized(evt);
		}
	    });
        addKeyListener(new java.awt.event.KeyAdapter() {
		public void keyPressed(java.awt.event.KeyEvent evt) {
		    formKeyPressed(evt);
		}
	    });

        jNetworkDrawPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jNetworkDrawPanel.addMouseListener(new java.awt.event.MouseAdapter() {
		public void mouseClicked(java.awt.event.MouseEvent evt) {
		    jNetworkDrawPanelMouseClicked(evt);
		}
	    });

        org.jdesktop.layout.GroupLayout jNetworkDrawPanelLayout = new org.jdesktop.layout.GroupLayout(jNetworkDrawPanel);
        jNetworkDrawPanel.setLayout(jNetworkDrawPanelLayout);
        jNetworkDrawPanelLayout.setHorizontalGroup(
						   jNetworkDrawPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
						   .add(0, 855, Short.MAX_VALUE)
						   );
        jNetworkDrawPanelLayout.setVerticalGroup(
						 jNetworkDrawPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
						 .add(0, 635, Short.MAX_VALUE)
						 );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
				  layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
				  .add(layout.createSequentialGroup()
				       .addContainerGap()
				       .add(jNetworkDrawPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
				       .addContainerGap())
				  );
        layout.setVerticalGroup(
				layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
				.add(layout.createSequentialGroup()
				     .addContainerGap()
				     .add(jNetworkDrawPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
				     .addContainerGap())
				);
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_formKeyPressed
	// TODO add your handling code here:
	/*
        
        if(evt.getKeyChar() == 't'){
	pr = new PluggableRenderer(); 
	pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
	pr.setVertexStringer(new VertexStringer() {
	public String getLabel(ArchetypeVertex v) {
	return v.toString();
	}});
            
	EdgeStringer stringer = new EdgeStringer(){
	public String getLabel(ArchetypeEdge e) {
	return e.toString();
	}
	};
  
	pr.setEdgeStringer(stringer);
	pr.setVertexLabelCentering(true);
         
	pr.setVertexPaintFunction(new SNePSNodeColorFunction());
	pr.setVertexShapeFunction(new SNePSNodeShapeFunction());
           
          
	scaler = new ViewScalingControl();
          
         
	SparseGraph dsg = new SparseGraph();
	SNePSGUINode v1 = (SNePSGUINode)dsg.addVertex(new SNePSGUINode("m1!","Elephant is a subclass of Mammal","Ako(Elephant,Mammal)",SNePSGUINode.MOL));
	SNePSGUINode v2 = (SNePSGUINode)dsg.addVertex(new SNePSGUINode("Elephant","Elephant","Elephant",SNePSGUINode.BASE));
	SNePSGUINode v3 = (SNePSGUINode)dsg.addVertex(new SNePSGUINode("Mammal","Mammal","Mammal",SNePSGUINode.BASE));
	dsg.addVertex(new SNePSGUINode("p1","","",SNePSGUINode.PAT));
	dsg.addVertex(new SNePSGUINode("v1","","",SNePSGUINode.VAR));
	SNePSGUIArc e1 = new SNePSGUIArc("class1",v1,v2);
	SNePSGUIArc e2 = new SNePSGUIArc("class2",v1,v3);
	dsg.addEdge(e1);
	dsg.addEdge(e2);
          
	l = new FRLayout(dsg);
	vv = new VisualizationViewer(l, pr);
	MouseListener [] mls = vv.getMouseListeners();
	for (int i = 0; i < mls.length; i++){
	vv.removeMouseListener(mls[i]);
	}
	vv.addMouseListener(new java.awt.event.MouseAdapter() {
	public void mouseClicked(java.awt.event.MouseEvent evt) {
	jNetworkDrawPanelMouseClicked(evt);
	}
	});
	final DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
	vv.setGraphMouse(graphMouse);
	graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
               
	vv.setToolTipFunction(new SNePSGUIToolTipFunction());
	vv.setBounds(0,0,jNetworkDrawPanel.getWidth(),jNetworkDrawPanel.getHeight());
	vv.setBorder(javax.swing.BorderFactory.createEtchedBorder());
	scaler.scale(vv, 0.9f, vv.getCenter());
	vv.setBackground(Color.white);
	jNetworkDrawPanel.add(vv);
	jNetworkDrawPanel.validate();  } */
    }//GEN-LAST:event_formKeyPressed

    private void SaveImageItemMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SaveImageItemMouseExited
	// TODO add your handling code here:
        SaveAsMenu.setVisible(false);
    }//GEN-LAST:event_SaveImageItemMouseExited

    private void SaveImageItemMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SaveImageItemMouseEntered
	// TODO add your handling code here:
	//SaveImageItem.setBackground(Color.BLUE);
    }//GEN-LAST:event_SaveImageItemMouseEntered

    private void SaveAsMenuMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SaveAsMenuMouseExited
	// TODO add your handling code here:
        SaveAsMenu.setVisible(false);
    }//GEN-LAST:event_SaveAsMenuMouseExited

    private void SaveAsMenuMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SaveAsMenuMouseEntered
	// TODO add your handling code here:
        SaveAsMenu.setVisible(false);
        
    }//GEN-LAST:event_SaveAsMenuMouseEntered

    private void SaveImageItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SaveImageItemActionPerformed
	// TODO add your handling code here:
	SaveAsMenu.setVisible(false);
	if(workingImagePath != null)
	    fc = new JFileChooser(workingImagePath);
	else
	    fc = new JFileChooser();
	//Add a custom file filter and disable the default
	//(Accept All) file filter.
	javax.swing.filechooser.FileFilter displayed = new ImageFilter(include_eps_support);
	fc.addChoosableFileFilter(displayed);
	fc.addChoosableFileFilter(new BmpFilter());
	if (include_eps_support){
	    fc.addChoosableFileFilter(new EpsFilter());
	}
	fc.addChoosableFileFilter(new JpgFilter());
	fc.addChoosableFileFilter(new PctFilter());
	fc.addChoosableFileFilter(new PcxFilter());      
	fc.addChoosableFileFilter(new PngFilter());
	fc.addChoosableFileFilter(new PsdFilter());
	fc.addChoosableFileFilter(new RasFilter());
	fc.addChoosableFileFilter(new TgaFilter());
	fc.setFileFilter(displayed);
	fc.setAcceptAllFileFilterUsed(false);   
	int returnVal = fc.showSaveDialog(this);
        
	if (returnVal == JFileChooser.APPROVE_OPTION) {
	    File file = fc.getSelectedFile();
	    workingImagePath =  file.getParentFile();
	       

	    Dimension size = jNetworkDrawPanel.getSize();
	    BufferedImage myImage = new BufferedImage(size.width, size.height, BufferedImage.TYPE_INT_RGB);
	    Graphics g = myImage.createGraphics();
	    jNetworkDrawPanel.paint(g); 
		
	    try {
		String filePath = file.getPath(); 
		ImageFilter selected = null;
		if(!((new ImageFilter()).accept(file))){
			
		    selected = (ImageFilter)fc.getFileFilter();
		    filePath = filePath.concat("." + selected.getDefaultExtension());
			
		}
		else{
		    selected = (ImageFilter)fc.getFileFilter();
		}
		String ext = Utils.getExtension(file);
		if (include_eps_support) {
		    if((ext != null && ext.equals(Utils.eps)) || 
		       (selected.getDefaultExtension()).equals(Utils.eps)){
			EPSDump epsd = new EPSDump();
			//Component c = jNetworkDrawPanel;
			//System.out.println("Attempting to save eps to: "+ filePath);
			
			epsd.dumpComponent(new File(filePath), jNetworkDrawPanel);
			
		    }
		    else{
			com.sun.jimi.core.Jimi.putImage(myImage,filePath);
		    }
		}
		else {
		    com.sun.jimi.core.Jimi.putImage(myImage,filePath);
		} // end of else
		
	    }
	    catch (com.sun.jimi.core.JimiException ex) {
		ex.printStackTrace();
	    }
	    catch(IOException e){
		e.printStackTrace();
	    } 
	}
	    
            
    }//GEN-LAST:event_SaveImageItemActionPerformed

    
    private void jNetworkDrawPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jNetworkDrawPanelMouseClicked
	// TODO add your handling code here:
     
        if(evt.getButton() == MouseEvent.BUTTON3){
            SaveAsMenu.setLocation(this.getX() + jNetworkDrawPanel.getX() + evt.getX(), this.getY() + jNetworkDrawPanel.getY() + evt.getY() + VERTICAL_OFFSET);
            SaveAsMenu.setVisible(true);
        }
        else if(evt.getButton() == MouseEvent.BUTTON3){
            
        }
    }//GEN-LAST:event_jNetworkDrawPanelMouseClicked

   
    
    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
	// TODO add your handling code here:
        
        
        if(vv != null){
            //vv = new VisualizationViewer( l, r );
       
            vv.setBounds(0,0,jNetworkDrawPanel.getWidth(),jNetworkDrawPanel.getHeight());
            vv.setBorder(javax.swing.BorderFactory.createEtchedBorder());
            vv.restart();
            vv.repaint();
        }
        
        
    }//GEN-LAST:event_formComponentResized

     
    
    public void displayNetwork(SparseGraph dsg){
	pr = new PluggableRenderer(); 
	pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
	pr.setVertexStringer(new VertexStringer() {
		public String getLabel(ArchetypeVertex v) {
		    return v.toString();
		}});
            
	EdgeStringer stringer = new EdgeStringer(){
		public String getLabel(ArchetypeEdge e) {
		    return e.toString();
		}
	    };
	scaler = new ViewScalingControl();
         
	pr.setEdgeStringer(stringer);
	pr.setVertexLabelCentering(true);
         
	pr.setVertexPaintFunction(new SNePSNodeColorFunction());
	pr.setVertexShapeFunction(new SNePSNodeShapeFunction());
 
	l = new FRLayout(dsg);
	if(vv  != null){
	    jNetworkDrawPanel.remove(vv);
	    jNetworkDrawPanel.repaint();
	}
	vv = new VisualizationViewer(l, pr);
	MouseListener [] mls = vv.getMouseListeners();
	for (int i = 0; i < mls.length; i++){
	    vv.removeMouseListener(mls[i]);
	}
	vv.addMouseListener(new java.awt.event.MouseAdapter() {
		public void mouseClicked(java.awt.event.MouseEvent evt) {
		    jNetworkDrawPanelMouseClicked(evt);
		}
            
		public void mousePressed(java.awt.event.MouseEvent evt){
                
		}
	    });
          
	final DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
	vv.setGraphMouse(graphMouse);
	graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
	vv.setToolTipFunction(new SNePSGUIToolTipFunction());
	vv.setBackground(Color.white);
	vv.setBounds(0,0,jNetworkDrawPanel.getWidth(),jNetworkDrawPanel.getHeight());
	vv.setBorder(javax.swing.BorderFactory.createEtchedBorder());
	scaler.scale(vv, 0.9f, vv.getCenter());
	jNetworkDrawPanel.add( vv );
	jNetworkDrawPanel.validate(); 
    }
        
    private class ImageFilter extends javax.swing.filechooser.FileFilter {

	private boolean filter_eps = false;

	public ImageFilter(){
	}

	public ImageFilter (boolean eps) {
	    filter_eps = eps;
	}
        //Accept all directories and all gif, jpg, tiff, or png files.
        public boolean accept(File f) {
	    if (f.isDirectory()) {
                return true;
	    }

	    String extension = Utils.getExtension(f);
	    if (extension != null) {
		if (extension.equalsIgnoreCase(Utils.bmp) ||
		    (filter_eps && extension.equalsIgnoreCase(Utils.eps)) ||
		    extension.equalsIgnoreCase(Utils.pct) ||
		    extension.equalsIgnoreCase(Utils.psd) ||
		    extension.equalsIgnoreCase(Utils.jpeg) ||
		    extension.equalsIgnoreCase(Utils.jpg) ||
		    extension.equalsIgnoreCase(Utils.ras) ||
		    extension.equalsIgnoreCase(Utils.tga) || 
		    extension.equalsIgnoreCase(Utils.pcx) || 
		    extension.equalsIgnoreCase(Utils.png)) {
                    return true;
		} else {
		    return false;
		}
	    }

	    return false;
	}

	public String getDefaultExtension (){
	    return "jpg";
	}
    
	//The description of this filter
	public String getDescription() {
	    if(filter_eps){
		return "Image Files (*.bmp, *.eps,*.jpg, *.jpeg, *.pct, *.pcx, *.png, *.psd, *.ras, *.tga, *.xbm)";
	    }
	    else {
		return "Image Files (*.bmp,*.jpg, *.jpeg, *.pct, *.pcx, *.png, *.psd, *.ras, *.tga, *.xbm)";
	    }

	}
    }
    
    private class JpgFilter extends ImageFilter {
        
        public boolean accept(File f) {
            if (f.isDirectory()){
                return true;
            }
            String extension = Utils.getExtension(f);
	    if (extension != null && (extension.equalsIgnoreCase(Utils.jpg) || extension.equalsIgnoreCase(Utils.jpeg))) {
                return true;
	    }
	    else {
                return false;
	    }
        }
        
        public String getDefaultExtension (){
            return "jpg";
        }
        
        public String getDescription(){
            return "JPEG Files (*.jpeg, *.jpg)";
        }
    }
    
    private class BmpFilter extends ImageFilter {
        
        public boolean accept(File f) {
            if (f.isDirectory()){
                return true;
            }
            String extension = Utils.getExtension(f);
	    if (extension != null && (extension.equalsIgnoreCase(Utils.bmp) || extension.equalsIgnoreCase(Utils.xbm))) {
                return true;
	    }
	    else {
                return false;
	    }
        }
        
        public String getDefaultExtension (){
            return "bmp";
        }
        
        public String getDescription(){
            return "BitMap Files (*.bmp, *.xbm)";
        }
    }
     
     
        
    private class RasFilter extends ImageFilter {
        
        public boolean accept(File f) {
            if (f.isDirectory()){
                return true;
            }
            String extension = Utils.getExtension(f);
	    if (extension != null && extension.equalsIgnoreCase(Utils.ras)) {
                return true;
	    }
	    else {
                return false;
	    }
        }
        
        public String getDefaultExtension (){
            return "ras";
        }
        
        public String getDescription(){
            return "SUN Rasterfiles (*.ras)";
        }
    }
     
    private class PctFilter extends ImageFilter {
        
        public boolean accept(File f) {
            if (f.isDirectory()){
                return true;
            }
            String extension = Utils.getExtension(f);
	    if (extension != null && extension.equalsIgnoreCase(Utils.pct)) {
                return true;
	    }
	    else {
                return false;
	    }
        }
        
        public String getDefaultExtension (){
            return "pct";
        }
        
        public String getDescription(){
            return "Macintosh PICT Files (*.pct)";
        }
    } 
    
    private class PngFilter extends ImageFilter {
        
        public boolean accept(File f) {
            if (f.isDirectory()){
                return true;
            }
            String extension = Utils.getExtension(f);
	    if (extension != null && extension.equalsIgnoreCase(Utils.png)) {
                return true;
	    }
	    else {
                return false;
	    }
        }
        
        public String getDefaultExtension (){
            return "png";
        }
        public String getDescription(){
            return "Portable Network Graphics Files (*.png)";
        }
    } 
    
    private class TgaFilter extends ImageFilter {
        
        public boolean accept(File f) {
            if (f.isDirectory()){
                return true;
            }
            String extension = Utils.getExtension(f);
	    if (extension != null && extension.equalsIgnoreCase(Utils.tga)) {
                return true;
	    }
	    else {
                return false;
	    }
        }
        
        public String getDefaultExtension (){
            return "tga";
        }
        
        public String getDescription(){
            return "Targa Files (*.tga)";
        }
    } 
    
    
    private class EpsFilter extends ImageFilter {
	
        public boolean accept(File f) {
            if (f.isDirectory()){
                return true;
            }
            String extension = Utils.getExtension(f);
	    if (extension != null && extension.equalsIgnoreCase(Utils.eps)) {
                return true;
	    }
	    else {
                return false;
	    }
        }
        
        public String getDefaultExtension (){
            return "eps";
        }
        
        public String getDescription(){
            return "Extended Postscript (*.eps)";
        }
    }

    private class PsdFilter extends ImageFilter {
        
        public boolean accept(File f) {
            if (f.isDirectory()){
                return true;
            }
            String extension = Utils.getExtension(f);
	    if (extension != null && extension.equalsIgnoreCase(Utils.psd)) {
                return true;
	    }
	    else {
                return false;
	    }
        }
        
        public String getDefaultExtension (){
            return "psd";
        }
        
        public String getDescription(){
            return "Adobe Photoshop Files (*.psd)";
        }
    } 
    
    private class PcxFilter extends ImageFilter {
        
        public boolean accept(File f) {
            if (f.isDirectory()){
                return true;
            }
            String extension = Utils.getExtension(f);
	    if (extension != null && extension.equalsIgnoreCase(Utils.pcx)) {
                return true;
	    }
	    else {
                return false;
	    }
        }
        
        public String getDefaultExtension (){
            return "pcx";
        }
        
        public String getDescription(){
            return "PCX Files (*.pcx)";
        }
    } 
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
		public void run() {
		    new SNePSGUIShow(false).setVisible(true);
		}
	    });
       
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPopupMenu SaveAsMenu;
    private javax.swing.JMenuItem SaveImageItem;
    private javax.swing.JPanel jNetworkDrawPanel;
    // End of variables declaration//GEN-END:variables
    
}                          
