/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.comparators;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.collections.AbstractTestObject;

public abstract class AbstractTestComparator
extends AbstractTestObject {
    public AbstractTestComparator(String testName) {
        super(testName);
    }

    public abstract Comparator makeComparator();

    public abstract List getComparableObjectsOrdered();

    public Object makeObject() {
        return this.makeComparator();
    }

    public boolean supportsEmptyCollections() {
        return false;
    }

    public boolean supportsFullCollections() {
        return false;
    }

    public String getCompatibilityVersion() {
        return "2";
    }

    protected void reverseObjects(List list) {
        Collections.reverse(list);
    }

    protected void randomizeObjects(List list) {
        Collections.shuffle(list);
    }

    protected void sortObjects(List list, Comparator comparator) {
        Collections.sort(list, comparator);
    }

    public void testEmptyListSort() {
        LinkedList list = new LinkedList();
        this.sortObjects(list, this.makeComparator());
        LinkedList list2 = new LinkedList();
        Assert.assertTrue((String)"Comparator cannot sort empty lists", (boolean)list2.equals(list));
    }

    public void testReverseListSort() {
        Comparator comparator = this.makeComparator();
        List randomList = this.getComparableObjectsOrdered();
        this.reverseObjects(randomList);
        this.sortObjects(randomList, comparator);
        List orderedList = this.getComparableObjectsOrdered();
        Assert.assertTrue((String)"Comparator did not reorder the List correctly", (boolean)orderedList.equals(randomList));
    }

    public void testRandomListSort() {
        Comparator comparator = this.makeComparator();
        List randomList = this.getComparableObjectsOrdered();
        this.randomizeObjects(randomList);
        this.sortObjects(randomList, comparator);
        List orderedList = this.getComparableObjectsOrdered();
        Assert.assertTrue((String)"Comparator did not reorder the List correctly", (boolean)orderedList.equals(randomList));
    }

    public void testComparatorIsSerializable() {
        Comparator comparator = this.makeComparator();
        Assert.assertTrue((String)"This comparator should be Serializable.", (boolean)(comparator instanceof Serializable));
    }

    public String getCanonicalComparatorName(Object object) {
        StringBuffer retval = new StringBuffer();
        retval.append("data/test/");
        String colName = object.getClass().getName();
        colName = colName.substring(colName.lastIndexOf(".") + 1, colName.length());
        retval.append(colName);
        retval.append(".version");
        retval.append(this.getCompatibilityVersion());
        retval.append(".obj");
        return retval.toString();
    }

    public void testComparatorCompatibility() throws IOException, ClassNotFoundException {
        if (!this.skipSerializedCanonicalTests()) {
            Comparator comparator = null;
            try {
                comparator = (Comparator)this.readExternalFormFromDisk(this.getCanonicalComparatorName(this.makeComparator()));
            }
            catch (FileNotFoundException exception) {
                boolean autoCreateSerialized = false;
                if (autoCreateSerialized) {
                    comparator = this.makeComparator();
                    String fileName = this.getCanonicalComparatorName(comparator);
                    this.writeExternalFormToDisk((Serializable)((Object)comparator), fileName);
                    Assert.fail((String)("Serialized form could not be found.  A serialized version has now been written (and should be added to CVS): " + fileName));
                }
                Assert.fail((String)("The Serialized form could be located to test serialization compatibility: " + exception.getMessage()));
            }
            List randomList = this.getComparableObjectsOrdered();
            this.reverseObjects(randomList);
            this.sortObjects(randomList, comparator);
            List orderedList = this.getComparableObjectsOrdered();
            Assert.assertTrue((String)"Comparator did not reorder the List correctly", (boolean)orderedList.equals(randomList));
        }
    }
}

