/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import junit.framework.Assert;
import org.apache.commons.collections.BulkTest;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.iterators.AbstractTestOrderedMapIterator;
import org.apache.commons.collections.map.AbstractTestIterableMap;

public abstract class AbstractTestOrderedMap
extends AbstractTestIterableMap {
    public AbstractTestOrderedMap(String testName) {
        super(testName);
    }

    public Map makeConfirmedMap() {
        return new TreeMap(new NullComparator());
    }

    public Object[] getSampleKeys() {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(super.getSampleKeys()));
        Collections.sort(list, new NullComparator());
        return list.toArray();
    }

    public void testFirstKey() {
        this.resetEmpty();
        OrderedMap ordered = (OrderedMap)this.map;
        try {
            ordered.firstKey();
            Assert.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        this.resetFull();
        ordered = (OrderedMap)this.map;
        Object confirmedFirst = this.confirmed.keySet().iterator().next();
        Assert.assertEquals(confirmedFirst, (Object)ordered.firstKey());
    }

    public void testLastKey() {
        this.resetEmpty();
        OrderedMap ordered = (OrderedMap)this.map;
        try {
            ordered.lastKey();
            Assert.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        this.resetFull();
        ordered = (OrderedMap)this.map;
        Object confirmedLast = null;
        Iterator it = this.confirmed.keySet().iterator();
        while (it.hasNext()) {
            confirmedLast = it.next();
        }
        Assert.assertEquals(confirmedLast, (Object)ordered.lastKey());
    }

    public void testNextKey() {
        this.resetEmpty();
        OrderedMap ordered = (OrderedMap)this.map;
        Assert.assertEquals(null, (Object)ordered.nextKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                Assert.assertEquals(null, (Object)ordered.nextKey(null));
            }
            catch (NullPointerException ex) {}
        } else {
            Assert.assertEquals(null, (Object)ordered.nextKey(null));
        }
        this.resetFull();
        ordered = (OrderedMap)this.map;
        Iterator it = this.confirmed.keySet().iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            Assert.assertEquals(confirmedObject, (Object)ordered.nextKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        Assert.assertEquals(null, (Object)ordered.nextKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            try {
                ordered.nextKey(null);
                Assert.fail();
            }
            catch (NullPointerException ex) {}
        } else {
            Assert.assertEquals(null, (Object)ordered.nextKey(null));
        }
    }

    public void testPreviousKey() {
        this.resetEmpty();
        OrderedMap ordered = (OrderedMap)this.map;
        Assert.assertEquals(null, (Object)ordered.previousKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                Assert.assertEquals(null, (Object)ordered.previousKey(null));
            }
            catch (NullPointerException ex) {}
        } else {
            Assert.assertEquals(null, (Object)ordered.previousKey(null));
        }
        this.resetFull();
        ordered = (OrderedMap)this.map;
        ArrayList list = new ArrayList(this.confirmed.keySet());
        Collections.reverse(list);
        Iterator it = list.iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            Assert.assertEquals(confirmedObject, (Object)ordered.previousKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        Assert.assertEquals(null, (Object)ordered.previousKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            try {
                ordered.previousKey(null);
                Assert.fail();
            }
            catch (NullPointerException ex) {}
        } else if (!this.isAllowNullKey()) {
            Assert.assertEquals(null, (Object)ordered.previousKey(null));
        }
    }

    public BulkTest bulkTestOrderedMapIterator() {
        return new InnerTestOrderedMapIterator();
    }

    public class InnerTestOrderedMapIterator
    extends AbstractTestOrderedMapIterator {
        public InnerTestOrderedMapIterator() {
            super("InnerTestOrderedMapIterator");
        }

        public boolean supportsRemove() {
            return AbstractTestOrderedMap.this.isRemoveSupported();
        }

        public boolean isGetStructuralModify() {
            return AbstractTestOrderedMap.this.isGetStructuralModify();
        }

        public boolean supportsSetValue() {
            return AbstractTestOrderedMap.this.isSetValueSupported();
        }

        public MapIterator makeEmptyMapIterator() {
            AbstractTestOrderedMap.this.resetEmpty();
            return ((OrderedMap)AbstractTestOrderedMap.this.map).orderedMapIterator();
        }

        public MapIterator makeFullMapIterator() {
            AbstractTestOrderedMap.this.resetFull();
            return ((OrderedMap)AbstractTestOrderedMap.this.map).orderedMapIterator();
        }

        public Map getMap() {
            return AbstractTestOrderedMap.this.map;
        }

        public Map getConfirmedMap() {
            return AbstractTestOrderedMap.this.confirmed;
        }

        public void verify() {
            super.verify();
            AbstractTestOrderedMap.this.verify();
        }
    }
}

