/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.KPartiteGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.impl.AbstractSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.PredicateUtils;
import edu.uci.ics.jung.utils.TypedVertexGenerator;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import edu.uci.ics.jung.utils.VertexGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.Predicate;

public class FoldingTransformer {
    public static final String FOLDED_DATA = "edu.uci.ics.jung.graph.KPartiteFolder:Folded Data";
    protected boolean parallel;
    protected UserDataContainer.CopyAction copy_action = UserData.REMOVE;
    private boolean undirected;

    public FoldingTransformer(boolean parallel) {
        this.parallel = parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setCopyAction(UserDataContainer.CopyAction copy_action) {
        this.copy_action = copy_action;
    }

    public Graph fold(KPartiteGraph g, Predicate p) {
        return this.fold(g, p, null);
    }

    public Graph fold(KPartiteGraph g, Predicate p, NumberEdgeValue nev) {
        ArchetypeVertex v;
        this.checkGraphConstraints(g);
        Graph newGraph = this.createGraph();
        Set vertices = PredicateUtils.getVertices(g, p);
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            v = (ArchetypeVertex)iter.next();
            v.copy(newGraph);
        }
        iter = vertices.iterator();
        while (iter.hasNext()) {
            v = (Vertex)iter.next();
            Vertex v_new = (Vertex)v.getEqualVertex(newGraph);
            Set succs = v.getSuccessors();
            Iterator s_iter = succs.iterator();
            while (s_iter.hasNext()) {
                Vertex s = (Vertex)s_iter.next();
                Set s_succs = s.getSuccessors();
                Iterator t_iter = s_succs.iterator();
                while (t_iter.hasNext()) {
                    Vertex t = (Vertex)t_iter.next();
                    if (!vertices.contains(t)) continue;
                    Vertex t_new = (Vertex)t.getEqualVertex(newGraph);
                    this.addEdge(newGraph, v_new, s, t_new, nev);
                }
            }
        }
        return newGraph;
    }

    public Graph fold(Hypergraph h, Graph target, boolean use_vertices, NumberEdgeValue nev, BidiMap map) {
        Set edges;
        Set vertices;
        VertexGenerator vg;
        this.undirected = true;
        if (target == null) {
            target = this.createGraph();
        }
        if ((vg = GraphUtils.getVertexGenerator(target)) == null) {
            vg = new TypedVertexGenerator(target);
        }
        HashMap<Element, Vertex> m = new HashMap<Element, Vertex>();
        if (use_vertices) {
            vertices = h.getVertices();
            edges = h.getEdges();
        } else {
            vertices = h.getEdges();
            edges = h.getVertices();
        }
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            Element av = (Element)iter.next();
            Vertex v = vg.create();
            v.importUserData(av);
            target.addVertex(v);
            m.put(av, v);
            map.put((Object)v, (Object)av);
        }
        iter = edges.iterator();
        while (iter.hasNext()) {
            Element he = (Element)iter.next();
            Set elts = he.getIncidentElements();
            Vertex[] v_array = new Vertex[elts.size()];
            int i = 0;
            Iterator e_iter = elts.iterator();
            while (e_iter.hasNext()) {
                v_array[i++] = (Vertex)m.get(e_iter.next());
            }
            for (i = 0; i < v_array.length; ++i) {
                for (int j = i + 1; j < v_array.length; ++j) {
                    this.addEdge(target, v_array[i], he, v_array[j], nev);
                }
            }
        }
        return target;
    }

    protected void addEdge(Graph newGraph, Vertex firstEnd, Element intermediate, Vertex secondEnd, NumberEdgeValue nev) {
        if (this.undirected && firstEnd == secondEnd) {
            return;
        }
        if (this.parallel) {
            AbstractSparseEdge v_t = this.undirected ? new UndirectedSparseEdge(firstEnd, secondEnd) : new DirectedSparseEdge(firstEnd, secondEnd);
            if (nev != null) {
                nev.setNumber(v_t, new Integer(1));
            } else {
                v_t.addUserDatum(FOLDED_DATA, intermediate, this.copy_action);
            }
            newGraph.addEdge(v_t);
        } else {
            Edge v_t = firstEnd.findEdge(secondEnd);
            if (v_t == null) {
                v_t = this.undirected ? new UndirectedSparseEdge(firstEnd, secondEnd) : new DirectedSparseEdge(firstEnd, secondEnd);
                if (nev != null) {
                    nev.setNumber(v_t, new Integer(0));
                } else {
                    v_t.addUserDatum(FOLDED_DATA, new HashSet(), this.copy_action);
                }
                newGraph.addEdge(v_t);
            }
            if (nev != null) {
                nev.setNumber(v_t, new Integer(nev.getNumber(v_t).intValue() + 1));
            } else {
                Set folded_vertices = (Set)v_t.getUserDatum(FOLDED_DATA);
                folded_vertices.add(intermediate);
            }
        }
    }

    protected Graph createGraph() {
        SparseGraph newGraph = this.undirected ? new UndirectedSparseGraph() : new DirectedSparseGraph();
        if (this.parallel) {
            newGraph.getEdgeConstraints().remove(Graph.NOT_PARALLEL_EDGE);
        }
        return newGraph;
    }

    protected void checkGraphConstraints(KPartiteGraph g) {
        this.undirected = PredicateUtils.enforcesUndirected(g);
        if (!this.undirected && !PredicateUtils.enforcesDirected(g)) {
            throw new IllegalArgumentException("Graph must be strictly directed or strictly undirected (no mixed graphs allowed)");
        }
    }
}

