/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import cern.jet.random.engine.DRand;
import cern.jet.random.engine.RandomEngine;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.visualization.VertexLocationFunction;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RandomVertexLocationDecorator
implements VertexLocationFunction {
    RandomEngine rand;
    Map v_locations = new HashMap();
    Dimension dim;

    public RandomVertexLocationDecorator(Dimension d) {
        this.rand = new DRand((int)new Date().getTime());
        this.dim = d;
    }

    public RandomVertexLocationDecorator(Dimension d, int seed) {
        this.rand = new DRand(seed);
        this.dim = d;
    }

    public void reset() {
        this.v_locations.clear();
    }

    public Point2D getLocation(ArchetypeVertex v) {
        Point2D location = (Point2D)this.v_locations.get(v);
        if (location == null) {
            location = new Point2D.Double(this.rand.nextDouble() * (double)this.dim.width, this.rand.nextDouble() * (double)this.dim.height);
            this.v_locations.put(v, location);
        }
        return location;
    }

    public Iterator getVertexIterator() {
        return this.v_locations.keySet().iterator();
    }
}

